/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.ISO8601Utils;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEngage;
import com.moengage.core.Properties;
import com.moengage.core.R;
import com.moengage.core.SdkConfig;
import com.moengage.core.internal.AdvertisingIdClient;
import com.moengage.core.model.DataTypes;
import com.moengage.core.model.MoEAttribute;
import com.moengage.core.model.UserAttribute;
import com.moengage.core.model.ViewDimension;
import com.moengage.core.utils.ReflectionUtils;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MoEUtils {
    private static final String TAG = "Core_MoEUtils";
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    public static int[] MONTH_NUMBERS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};

    @Nullable
    static String getOperatorName(Context context) {
        try {
            if (!SdkConfig.getConfig().trackingOptOut.isCarrierOptedOut() && MoEHelperUtils.hasPermission(context, "android.permission.READ_PHONE_STATE") && MoEUtils.hasFeature(context, "android.hardware.telephony")) {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                return telephonyManager.getSimOperatorName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String convertBundletoJSONString(Bundle newBundle) {
        Set keys = newBundle.keySet();
        JSONObject jsonObject = new JSONObject();
        for (String key : keys) {
            try {
                jsonObject.put(key, newBundle.get(key));
            }
            catch (Exception e) {
                Logger.e("MoEUtils:convertBundletoJSONString", e);
            }
        }
        return jsonObject.toString();
    }

    public static void showNormalDialogWithOk(String message, Context context) {
        if (null == context) {
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setMessage((CharSequence)message).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    public static void showCouponDialog(String message, final String couponcode, final Context context) {
        if (null == context) {
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setMessage((CharSequence)message).setPositiveButton((CharSequence)"Copy Code", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                MoEHelperUtils.copyCouponCodeToClipboard(context, couponcode);
                Properties properties = new Properties();
                properties.addAttribute("coupon_code", couponcode);
                MoEHelper.getInstance(context).trackEvent("EVENT_ACTION_COUPON_CODE_COPY", properties);
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    @Nullable
    public static AdvertisingIdClient.AdInfo getAdvertisementInfo(Context context) {
        try {
            return AdvertisingIdClient.getAdvertisingIdInfo(context);
        }
        catch (Exception e) {
            try {
                Object adInfo = ReflectionUtils.invokeStatic("com.google.android.gms.ads.identifier.AdvertisingIdClient", "getAdvertisingIdInfo", new Class[]{Context.class}, new Object[]{context});
                if (null != adInfo) {
                    String advertisingId = (String)ReflectionUtils.invokeInstance(adInfo, "getId", null, null);
                    boolean isLimit = (Boolean)ReflectionUtils.invokeInstance(adInfo, "isLimitAdTrackingEnabled", null, null);
                    return new AdvertisingIdClient.AdInfo(TextUtils.isEmpty((CharSequence)advertisingId) ? null : advertisingId, isLimit ? 1 : 0);
                }
                Logger.v("It is advised that you add ----> com.google.android.gms:play-services-ads:7.5.0");
            }
            catch (Exception e2) {
                Logger.e("MoEUtils:getAdvertisementInfo", e2);
            }
            return null;
        }
    }

    public static boolean hasFeature(Context context, String feature) {
        return context.getPackageManager().hasSystemFeature(feature);
    }

    public static boolean isNullOrEmpty(CharSequence text) {
        return TextUtils.isEmpty((CharSequence)text) || TextUtils.getTrimmedLength((CharSequence)text) == 0;
    }

    public static boolean isNullOrEmpty(Collection collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean isNullOrEmpty(Map map) {
        return map == null || map.size() == 0;
    }

    public static <T> T getSystemService(Context context, String serviceConstant) {
        return (T)context.getSystemService(serviceConstant);
    }

    public static String getAndroidID(Context context) {
        String androidId;
        if (!(SdkConfig.getConfig().trackingOptOut.isAndroidIdOptedOut() || MoEUtils.isNullOrEmpty(androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id")) || "9774d56d682e549c".equals(androidId) || "unknown".equals(androidId) || "000000000000000".equals(androidId))) {
            return androidId;
        }
        return null;
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getNetworkType(Context context) {
        try {
            NetworkInfo wifiInfo;
            if (MoEHelperUtils.hasPermission(context, "android.permission.ACCESS_WIFI_STATE") && null != (wifiInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(1)) && wifiInfo.isConnectedOrConnecting()) {
                return "wifi";
            }
            if (MoEHelperUtils.hasPermission(context, "android.permission.READ_PHONE_STATE") && MoEUtils.hasFeature(context, "android.hardware.telephony")) {
                TelephonyManager telephonyManager = (TelephonyManager)MoEUtils.getSystemService(context, "phone");
                int type = telephonyManager.getNetworkType();
                switch (type) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return "2G";
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return "3G";
                    }
                    case 13: {
                        return "4G";
                    }
                }
                return "CouldNotDetermine";
            }
        }
        catch (Exception e) {
            Logger.e("MoEUtils: getNetworkType", e);
        }
        return null;
    }

    static void trackActivityStates(String activityState, String activityName, Context context) {
        try {
            Properties activityJson = new Properties();
            activityJson.addAttribute("ACTIVITY_NAME", activityName);
            MoEHelper.getInstance(context).trackEvent(activityState, activityJson);
        }
        catch (Exception e) {
            Logger.e("MoEUtils :trackActivityStates", e);
        }
    }

    @Nullable
    public static Bundle convertMapToBundle(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            Logger.e("MoEUtils#convertMapToBundle : Exception", e);
        }
        return bundle;
    }

    @Nullable
    public static Bundle jsonToBundle(JSONObject json) {
        if (json == null) {
            return null;
        }
        try {
            Bundle bundle = new Bundle();
            Iterator iter = json.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = json.getString(key);
                bundle.putString(key, value);
            }
            return bundle;
        }
        catch (JSONException e) {
            Logger.e("MoEUtils : jsonToBundle", e);
            return null;
        }
    }

    public static void updateTestDeviceState(Context context) {
        long registeredTime = ConfigurationProvider.getInstance(context).getVerificationRegistrationTime();
        if (registeredTime + 3600000L < System.currentTimeMillis()) {
            ConfigurationProvider.getInstance(context).setVerificationRegistration(false);
        }
    }

    @Nullable
    static UserAttribute getUserAttributePoJo(JSONObject userJSON) {
        UserAttribute userAttribute = null;
        try {
            Iterator jsonKeys = userJSON.keys();
            while (jsonKeys.hasNext()) {
                userAttribute = new UserAttribute();
                userAttribute.userAttributeName = (String)jsonKeys.next();
                userAttribute.userAttributeValue = userJSON.getString(userAttribute.userAttributeName);
            }
        }
        catch (Exception e) {
            Logger.e("MoEDispatcher : getUserAttributePoJo", e);
        }
        return userAttribute;
    }

    static boolean shouldSendUserAttribute(UserAttribute currentUserAttributes, UserAttribute savedUserAttributes) {
        return currentUserAttributes == null || savedUserAttributes == null || !savedUserAttributes.equals(currentUserAttributes);
    }

    @Nullable
    static UserAttribute getSavedUserAttribute(Context context, String userAttributeName) {
        return MoEDAO.getInstance(context).getUserAttributeByName(userAttributeName);
    }

    public static String getRequestId() {
        return String.valueOf(MoEUtils.currentMillis()) + "-" + UUID.randomUUID().toString();
    }

    public static String getTimeInISO(long timeMillis) {
        Date currentDate = new Date();
        currentDate.setTime(timeMillis);
        return ISO8601Utils.format(currentDate);
    }

    public static String getSha1ForString(String inputString) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(inputString.getBytes());
            return MoEUtils.bytesToHex(md.digest());
        }
        catch (Exception e) {
            Logger.e("MoEUtils getSha1ForString() : Exception ", e);
            return inputString;
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    @Nullable
    public static String getAppId() {
        return SdkConfig.getConfig().appId;
    }

    public static long currentMillis() {
        return System.currentTimeMillis();
    }

    public static String currentISOTime() {
        return MoEUtils.getTimeInISO(MoEUtils.currentMillis());
    }

    @Nullable
    @WorkerThread
    public static String getUserAttributeUniqueId(Context context) {
        try {
            MoEAttribute attribute = MoEDAO.getInstance(context).getAttributeByName("USER_ATTRIBUTE_UNIQUE_ID");
            if (attribute != null) {
                return attribute.getValue();
            }
            return ConfigurationProvider.getInstance(context).getUserAttributeUniqueId();
        }
        catch (Exception e) {
            Logger.e("Core_MoEUtils getUserAttributeUniqueId() : ", e);
            return null;
        }
    }

    @Nullable
    public static MoEAttribute convertJsonToAttributeObject(JSONObject attributeJson) throws JSONException {
        Iterator jsonKeys = attributeJson.keys();
        if (jsonKeys.hasNext()) {
            String attributeName = (String)jsonKeys.next();
            Object attributeValue = attributeJson.get(attributeName);
            return new MoEAttribute(attributeName, attributeValue.toString(), MoEUtils.currentMillis(), MoEUtils.getDataTypeForObject(attributeValue).toString());
        }
        return null;
    }

    public static DataTypes getDataTypeForObject(Object value) {
        if (value instanceof Integer) {
            return DataTypes.INTEGER;
        }
        if (value instanceof Double) {
            return DataTypes.DOUBLE;
        }
        if (value instanceof Long) {
            return DataTypes.LONG;
        }
        if (value instanceof Boolean) {
            return DataTypes.BOOLEAN;
        }
        if (value instanceof Float) {
            return DataTypes.FLOAT;
        }
        return DataTypes.STRING;
    }

    public static boolean isXiaomiDevice(String manufacturer) {
        return "Xiaomi".equals(manufacturer);
    }

    public static String deviceManufacturer() {
        return Build.MANUFACTURER;
    }

    public static boolean isDate(String attributeString) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
            long epoch = format.parse(attributeString).getTime();
            return epoch > -1L;
        }
        catch (Exception e) {
            Logger.v("Core_MoEUtils isDate() : Exception: Could not convert string to date: " + attributeString);
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'", Locale.ENGLISH);
                long epoch = format.parse(attributeString).getTime();
                return epoch > -1L;
            }
            catch (Exception e2) {
                Logger.v("Core_MoEUtils isDate() : Exception: Could not convert string to date: " + attributeString);
                return false;
            }
        }
    }

    public static boolean isEmptyString(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean hasKeys(JSONObject jsonObject) {
        return jsonObject != null && jsonObject.length() > 0;
    }

    public static String getDateDataPointFormat() {
        Calendar c = Calendar.getInstance();
        int hours = c.get(11);
        int mins = c.get(12);
        int secs = c.get(13);
        int day = c.get(5);
        int month = MONTH_NUMBERS[c.get(2)];
        int year = c.get(1);
        StringBuilder dateString = new StringBuilder().append(day).append(":").append(month).append(":").append(year).append(":").append(hours).append(":").append(mins).append(":").append(secs);
        return dateString.toString();
    }

    public static Map<String, Object> jsonToMap(JSONObject payloadJson) {
        if (payloadJson == null || payloadJson.length() == 0) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> map = new HashMap<String, Object>(payloadJson.length());
        Iterator iterator = payloadJson.keys();
        try {
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                map.put(key, payloadJson.get(key));
            }
        }
        catch (Exception e) {
            Logger.e("Core_MoEUtils jsonToMap() : Exception ", e);
        }
        return map;
    }

    public static long currentSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long secondsFromIsoString(String isoString) {
        if (!isoString.endsWith("Z")) {
            isoString = isoString + "Z";
        }
        return ISO8601Utils.parse(isoString).getTime() / 1000L;
    }

    public static String isoStringFromSeconds(long seconds) {
        return ISO8601Utils.format(new Date(seconds * 1000L));
    }

    public static void logJsonArray(String tag, JSONArray jsonArray) {
        try {
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                Logger.v(tag + "\n" + jsonObject.toString(4));
            }
        }
        catch (JSONException e) {
            Logger.e("Core_MoEUtils logJsonArray() : ", e);
        }
    }

    public static <T> void logCollection(String tag, List<T> list) {
        for (T item : list) {
            Logger.v(tag + "\n" + item);
        }
    }

    static boolean isDebugBuild(Context context) {
        return 0 != (context.getApplicationInfo().flags & 2);
    }

    public static String getMd5FromString(String imageUrl) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(imageUrl.getBytes());
        return MoEUtils.bytesToHex(messageDigest.digest());
    }

    public static Bundle deepCopy(Bundle bundle) {
        Bundle newBundle = new Bundle();
        try {
            Set keys = bundle.keySet();
            for (String key : keys) {
                Object nextValue = bundle.get(key);
                if (nextValue instanceof Integer) {
                    newBundle.putInt(key, ((Integer)nextValue).intValue());
                    continue;
                }
                if (nextValue instanceof Boolean) {
                    newBundle.putBoolean(key, ((Boolean)nextValue).booleanValue());
                    continue;
                }
                if (nextValue instanceof String) {
                    newBundle.putString(key, (String)nextValue);
                    continue;
                }
                if (nextValue instanceof Byte) {
                    newBundle.putByte(key, ((Byte)nextValue).byteValue());
                    continue;
                }
                if (nextValue instanceof Character) {
                    newBundle.putChar(key, ((Character)nextValue).charValue());
                    continue;
                }
                if (nextValue instanceof Double) {
                    newBundle.putDouble(key, ((Double)nextValue).doubleValue());
                    continue;
                }
                if (nextValue instanceof Float) {
                    newBundle.putFloat(key, ((Float)nextValue).floatValue());
                    continue;
                }
                if (nextValue instanceof Long) {
                    newBundle.putLong(key, ((Long)nextValue).longValue());
                    continue;
                }
                if (!(nextValue instanceof Short)) continue;
                newBundle.putShort(key, ((Short)nextValue).shortValue());
            }
        }
        catch (Exception e) {
            return newBundle;
        }
        return newBundle;
    }

    static String formatAppId(String appId) {
        if (MoEUtils.isEmptyString(appId)) {
            return null;
        }
        if (MoEngage.isDebugBuild()) {
            return appId + "_DEBUG";
        }
        return appId;
    }

    public static ViewDimension getDeviceDimensions(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return new ViewDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
    }

    public static boolean isTablet(Context context) {
        return context.getResources().getBoolean(R.bool.moeIsTablet);
    }

    public static boolean isLandscapeMode(Context context) {
        return context.getResources().getBoolean(R.bool.moeIsLand);
    }

    public static int transformToPx(Context context, double dp) {
        return (int)TypedValue.applyDimension((int)1, (float)((float)dp), (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static void dumpIntentExtras(String tag, Bundle extras) {
        if (extras == null) {
            return;
        }
        Set ketSet = extras.keySet();
        if (ketSet == null || ketSet.isEmpty()) {
            return;
        }
        Logger.v(tag + " ------Start of bundle extras------");
        for (String key : ketSet) {
            Object obj = extras.get(key);
            if (null == obj) continue;
            Logger.v(tag + " [ " + key + " = " + obj.toString() + " ]");
        }
        Logger.v(tag + " -------End of bundle extras-------");
    }

    public static boolean isIsoDate(String isoString) {
        try {
            if (MoEUtils.isEmptyString(isoString)) {
                return false;
            }
            long epochTime = ISO8601Utils.parse(isoString).getTime();
            return epochTime > -1L;
        }
        catch (Exception e) {
            Logger.v("Core_MoEUtils isIsoDate() : Not an ISO Date String" + isoString);
            return false;
        }
    }

    public static boolean isGif(String imageUrl) {
        try {
            if (MoEUtils.isEmptyString(imageUrl)) {
                return false;
            }
            URL url = new URL(imageUrl);
            String path = url.getPath();
            return !MoEUtils.isEmptyString(path) && path.toLowerCase().endsWith(".gif");
        }
        catch (Exception e) {
            Logger.e("Core_MoEUtils isGif() : ", e);
            return false;
        }
    }

    public static long minutesToMillis(long minutes) {
        return MoEUtils.secondsToMillis(minutes * 60L);
    }

    public static long secondsToMillis(long seconds) {
        return seconds * 1000L;
    }

    public static JSONObject mapToJson(Map<String, Object> map) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            jsonObject.put(entry.getKey(), entry.getValue());
        }
        return jsonObject;
    }
}

