/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEngage;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.internal.AppCloseTask;

public class MoELifeCycleObserver
implements LifecycleObserver {
    private static final String TAG = "Core_MoELifeCycleObserver";
    private Context context;

    public MoELifeCycleObserver(@NonNull Context context) {
        Logger.v("Core_MoELifeCycleObserver MoELifeCycleObserver() : ");
        if (context == null) {
            Logger.v("Core_MoELifeCycleObserver MoELifeCycleObserver() : context is null.");
        } else {
            this.context = context.getApplicationContext();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void onStart() {
        Logger.v("Core_MoELifeCycleObserver onStart() : ");
        try {
            MoEngage.isAppForeground = true;
            if (this.context != null) {
                MoEDispatcher.getInstance(this.context).onAppOpen();
            }
        }
        catch (Exception e) {
            Logger.e("Core_MoELifeCycleObserver onStart() : Exception: ", e);
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onStop() {
        Logger.v("Core_MoELifeCycleObserver onStop() : ");
        try {
            MoEngage.isAppForeground = false;
            if (this.context != null) {
                TaskManager.getInstance().addTaskToQueue(new AppCloseTask(this.context));
            }
        }
        catch (Exception e) {
            Logger.e("Core_MoELifeCycleObserver onStop() : Exception: ", e);
        }
    }
}

