/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.MoEngage;
import com.moengage.core.SdkConfig;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.integrations.segment.TrackSegmentEventTask;
import com.moengage.core.integrations.segment.TrackSegmentUserAttributeTask;
import com.moengage.core.model.IntegrationMeta;
import com.moengage.core.model.IntegrationPartner;
import com.moengage.push.PushManager;
import java.util.Map;
import org.json.JSONObject;

public class MoEIntegrationHelper {
    private static final String TAG = "Core_MoEIntegrationHelper";
    private IntegrationPartner partner;
    private Context context;

    public MoEIntegrationHelper(Context context, IntegrationPartner partner) {
        this.partner = partner;
        this.context = context;
    }

    public static void setIntegrationMeta(@NonNull IntegrationMeta meta) {
        try {
            if (meta == null) {
                return;
            }
            Logger.v("Core_MoEIntegrationHelper setIntegrationMeta() : Meta: " + meta);
            ConfigurationCache.getInstance().setIntegrationType(meta.integrationType);
            ConfigurationCache.getInstance().setIntegrationVersion(meta.integrationVersion);
        }
        catch (Exception e) {
            Logger.e("Core_MoEIntegrationHelper setIntegrationMeta() : ", e);
        }
    }

    public void trackEvent(@NonNull String eventName, JSONObject eventAttributes) {
        try {
            if (this.context == null) {
                return;
            }
            Logger.v("Core_MoEIntegrationHelper trackEventFromSegment() : Event Name: " + eventName);
            Logger.v("Core_MoEIntegrationHelper trackEventFromSegment() : Attributes: " + eventAttributes);
            if (MoEUtils.isEmptyString(eventName)) {
                Logger.w("Core_MoEIntegrationHelper trackEventFromSegment() : Event name cannot be empty");
                return;
            }
            if (this.partner == IntegrationPartner.SEGMENT) {
                TaskManager.getInstance().addTaskToQueue(new TrackSegmentEventTask(this.context, eventName, eventAttributes));
            }
        }
        catch (Exception e) {
            Logger.e("Core_MoEIntegrationHelper trackEvent() : ", e);
        }
    }

    public void trackUserAttribute(Map<String, Object> userAttributesMap) {
        try {
            if (this.context == null || userAttributesMap == null) {
                return;
            }
            if (this.partner == IntegrationPartner.SEGMENT) {
                TaskManager.getInstance().addTaskToQueue(new TrackSegmentUserAttributeTask(this.context, userAttributesMap));
            }
        }
        catch (Exception e) {
            Logger.e("Core_MoEIntegrationHelper trackUserAttribute() : ", e);
        }
    }

    public void initialize(String appId, String senderId) {
        try {
            Logger.v("Core_MoEIntegrationHelper initialize() : App-id: " + appId);
            Logger.v("Core_MoEIntegrationHelper initialize() : Sender-Id: " + senderId);
            MoEngage.setBuildStatus(MoEUtils.isDebugBuild(this.context));
            if (MoEUtils.isEmptyString(appId)) {
                return;
            }
            SdkConfig.getConfig().appId = MoEUtils.formatAppId(appId);
            if (!MoEUtils.isEmptyString(senderId)) {
                SdkConfig.getConfig().pushConfig.fcm.setSenderId(senderId);
            }
            if (SdkConfig.getConfig().pushConfig.fcm.isRegistrationEnabled()) {
                PushManager.getInstance().registerForPush(this.context);
            }
        }
        catch (Exception e) {
            Logger.e("Core_MoEIntegrationHelper initialize() : ", e);
        }
    }

    public void trackAnonymousId(String anonymousId) {
        try {
            if (MoEUtils.isEmptyString(anonymousId)) {
                return;
            }
            if (this.partner == IntegrationPartner.SEGMENT) {
                ConfigurationProvider.getInstance(this.context).saveSegmentAnonymousId(anonymousId);
            }
        }
        catch (Exception e) {
            Logger.e("Core_MoEIntegrationHelper trackAnonymousId() : ", e);
        }
    }

    public void onActivityStart(Activity activity) {
        try {
            MoEHelper.getInstance(this.context).onStartInternal(activity);
        }
        catch (Exception e) {
            Logger.e("Core_MoEIntegrationHelper onActivityStart() : ", e);
        }
    }

    public void onActivityStop(Activity activity) {
        try {
            MoEHelper.getInstance(this.context).onStopInternal(activity);
        }
        catch (Exception e) {
            Logger.e("Core_MoEIntegrationHelper onActivityStop() : ", e);
        }
    }

    public void onActivityResumed(Activity activity) {
        try {
            MoEHelper.getInstance(this.context).onResumeInternal(activity);
        }
        catch (Exception e) {
            Logger.e("Core_MoEIntegrationHelper onActivityResumed() : ", e);
        }
    }

    public void onActivitySavedInstance(Activity activity, Bundle outState) {
        try {
            MoEHelper.getInstance(this.context).onSaveInstanceState(outState);
        }
        catch (Exception e) {
            Logger.e("Core_MoEIntegrationHelper onActivitySavedInstance() : ", e);
        }
    }
}

