/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.ActivityStartTask;
import com.moengage.core.AppOpenTask;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.DeviceAddManager;
import com.moengage.core.Logger;
import com.moengage.core.MoECallbacks;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDTManager;
import com.moengage.core.MoEFileManager;
import com.moengage.core.MoEUtils;
import com.moengage.core.MoEngage;
import com.moengage.core.NotificationClickedTask;
import com.moengage.core.Properties;
import com.moengage.core.RemoteConfig;
import com.moengage.core.SdkConfig;
import com.moengage.core.SetAliasTask;
import com.moengage.core.SetDeviceAttributeTask;
import com.moengage.core.cards.CardManager;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.OnTaskCompleteListener;
import com.moengage.core.executor.TaskManager;
import com.moengage.core.executor.TaskProcessor;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.internal.AppCloseTask;
import com.moengage.core.internal.MoEWorkerTask;
import com.moengage.core.internal.analytics.AnalyticsHelper;
import com.moengage.core.internal.inapp.InAppManager;
import com.moengage.core.internal.location.GeoManager;
import com.moengage.core.internal.pushamp.PushAmpManager;
import com.moengage.core.internal.remoteconfig.ConfigApiNetworkTask;
import com.moengage.core.internal.reports.DataManager;
import com.moengage.core.internal.storage.StorageProvider;
import com.moengage.core.listeners.AppBackgroundListener;
import com.moengage.core.listeners.OnAppBackgroundListener;
import com.moengage.core.listeners.OnLogoutCompleteListener;
import com.moengage.core.mipush.MiPushManager;
import com.moengage.push.PushManager;
import com.moengage.push.hms.puskit.PushKitManager;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class MoEDispatcher
implements OnTaskCompleteListener {
    private static final String TAG = "Core_MoEDispatcher";
    private Context context;
    private static MoEDispatcher instance;
    private boolean shouldTrackUniqueId = false;
    private JSONObject uniqueIdAttribute = null;
    private ScheduledExecutorService scheduler;
    private DeviceAddManager deviceAddManager = null;

    private MoEDispatcher(Context context) {
        if (context != null) {
            this.context = context;
            TaskProcessor.getInstance().setOnTaskCompleteListener(this);
        } else {
            Logger.v("Core_MoEDispatcher context is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MoEDispatcher getInstance(Context context) {
        if (instance != null) return instance;
        Class<MoEDispatcher> clazz = MoEDispatcher.class;
        synchronized (MoEDispatcher.class) {
            if (instance != null) return instance;
            instance = new MoEDispatcher(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void onStart(Activity activity, Intent intent) {
        try {
            if (!RemoteConfig.getConfig().isAppEnabled) {
                return;
            }
            if (null == activity) {
                Logger.v("Core_MoEDispatcher onStart activity instance is null");
                return;
            }
            if (null == intent) {
                intent = activity.getIntent();
            }
            this.context = activity.getApplicationContext();
            Logger.v("Core_MoEDispatcher onStart ----");
            MoEUtils.dumpIntentExtras(TAG, intent.getExtras());
            TaskManager.getInstance().addTaskToQueue(new ActivityStartTask(activity));
            InAppManager.getInstance().showInAppIfRequired(this.context);
            MoEUtils.updateTestDeviceState(this.context);
        }
        catch (Exception e) {
            Logger.e("Core_MoEDispatcher onStart() : ", e);
        }
    }

    public void trackNotificationClicked(long gtime) {
        if (!RemoteConfig.getConfig().isAppEnabled) {
            return;
        }
        TaskManager.getInstance().addTaskToQueue(new NotificationClickedTask(this.context, gtime));
    }

    public void setUserAttribute(JSONObject userJson) {
        MoEHelper.getInstance(this.context).getAttributeManager().setUserAttribute(userJson);
    }

    public void onResume(Activity activity, boolean isRestoring) {
        if (!RemoteConfig.getConfig().isAppEnabled) {
            return;
        }
        if (!isRestoring) {
            this.showDialogAfterPushClick(activity);
        }
    }

    public void onStop(Activity activity) {
        if (!RemoteConfig.getConfig().isAppEnabled) {
            return;
        }
        if (null == activity) {
            return;
        }
        int activityCounter = MoEHelper.getActivityCounter();
        Logger.d("Core_MoEDispatcher activity counter " + activityCounter);
        String activityName = activity.getClass().getName();
        if (!MoEUtils.isEmptyString(activityName)) {
            Logger.v("Core_MoEDispatcher " + activityName + " stopped");
        }
        if (activityCounter == 0 && SdkConfig.getConfig().isSegmentIntegration) {
            TaskManager.getInstance().addTaskToQueue(new AppCloseTask(this.context));
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @WorkerThread
    public void handleLogout(boolean isForcedLogout) {
        try {
            Logger.v("Core_MoEDispatcher handleLogout() : Started logout process");
            if (!RemoteConfig.getConfig().isAppEnabled) {
                return;
            }
            CardManager.getInstance().onLogout(this.context);
            this.trackLogoutEvent(isForcedLogout);
            DataManager.getInstance().batchData(this.context);
            DataManager.getInstance().sendData(this.context, SdkConfig.getConfig().appId, -1);
            InAppManager.getInstance().onLogout(this.context);
            MoEDAO.getInstance(this.context).clearDataOnLogout();
            new MoEFileManager(this.context).clearMoEngageFiles();
            AnalyticsHelper.getInstance(this.context).onLogout(this.context);
            PushManager.getInstance().registerForPush(this.context);
            this.getDeviceAddManager().registerDevice(this.context);
            this.notifyLogoutCompleteListener();
            Logger.v("Core_MoEDispatcher handleLogout() : Logout process complete.");
        }
        catch (Exception e) {
            Logger.e("Core_MoEDispatcher handleLogout() : ", e);
        }
    }

    @WorkerThread
    private void trackLogoutEvent(boolean isForcedLogout) {
        try {
            Properties eventAttributes = new Properties();
            if (isForcedLogout) {
                eventAttributes.addAttribute("type", "forced");
            }
            eventAttributes.setNonInteractive();
            Event event = new Event("MOE_LOGOUT", eventAttributes.getPayload().build());
            MoEDAO.getInstance(this.context).addEvent(event);
        }
        catch (Exception e) {
            Logger.e("Core_MoEDispatcher trackLogoutEvent(): ", e);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void sendInteractionData() {
        DataManager.getInstance().batchAndSyncData(this.context);
    }

    @WorkerThread
    public void setInboxMessageClicked(long id2) {
        MoEDAO.getInstance(this.context).setMessageClicked(id2);
    }

    @WorkerThread
    public void handleAppUpdateEvent() {
        try {
            if (!RemoteConfig.getConfig().isAppEnabled) {
                return;
            }
            int prevVersion = ConfigurationProvider.getInstance(this.context).getStoredAppVersion();
            Properties eventObj = new Properties();
            eventObj.addAttribute("VERSION_FROM", prevVersion);
            eventObj.addAttribute("VERSION_TO", ConfigurationProvider.getInstance(this.context).getAppVersion());
            Logger.i("Adding an update event");
            MoEHelper.getInstance(this.context).trackEvent("UPDATE", eventObj);
            if (!MoEngage.isAppForeground()) {
                this.sendInteractionData();
            }
        }
        catch (Exception e) {
            Logger.e("Adding update event", e);
        }
    }

    @Nullable
    @WorkerThread
    public Cursor getAllMessages() {
        return MoEDAO.getInstance(this.context).getMessages(this.context);
    }

    @WorkerThread
    public int getUnreadMessageCount() {
        return MoEDAO.getInstance(this.context).getUnreadMessageCount();
    }

    private void showDialogAfterPushClick(Activity activity) {
        if (null == activity) {
            return;
        }
        try {
            Bundle extras;
            Intent intent = activity.getIntent();
            if (intent != null && (extras = intent.getExtras()) != null && extras.containsKey("gcm_show_dialog")) {
                intent.removeExtra("gcm_show_dialog");
                if (extras.containsKey("gcm_coupon_code")) {
                    MoEUtils.showCouponDialog(extras.getString("gcm_alert"), extras.getString("gcm_coupon_code"), (Context)activity);
                    intent.removeExtra("gcm_alert");
                    intent.removeExtra("gcm_coupon_code");
                } else {
                    MoEUtils.showNormalDialogWithOk(extras.getString("gcm_alert"), (Context)activity);
                    intent.removeExtra("gcm_alert");
                }
            }
        }
        catch (Exception e) {
            Logger.e("Core_MoEDispatcher showDialogAfterPushClick : ", e);
        }
    }

    @Deprecated
    public void addTaskToQueueBeginning(ITask task) {
        TaskManager.getInstance().addTaskToQueueBeginning(task);
    }

    @Deprecated
    public void startTask(ITask task) {
        TaskManager.getInstance().startTask(task);
    }

    @Override
    public void onTaskComplete(String tag, TaskResult taskResult) {
        Logger.v("Task completed : " + tag);
        switch (tag) {
            case "TRACK_ATTRIBUTE": {
                if (taskResult.isSuccess()) break;
                this.shouldTrackUniqueId = true;
                this.uniqueIdAttribute = (JSONObject)taskResult.getPayload();
                break;
            }
            case "DEVICE_ADD": {
                this.deviceAddManager.processTaskResult(this.context, taskResult);
                break;
            }
            case "LOGOUT_TASK": {
                if (!this.shouldTrackUniqueId) break;
                this.trackChangedUniqueId();
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void syncConfigIfRequired() {
        if (StorageProvider.INSTANCE.getRepository(this.context, SdkConfig.getConfig()).getConfigSyncTime() + MoEConstants.CONFIG_API_SYNC_DELAY < MoEUtils.currentMillis()) {
            TaskManager.getInstance().startTask(new ConfigApiNetworkTask(this.context));
        }
        TaskManager.getInstance().startTask(new ConfigApiNetworkTask(this.context));
    }

    public void trackDeviceLocale() {
        try {
            if (!RemoteConfig.getConfig().isAppEnabled) {
                return;
            }
            this.trackDeviceAndUserAttribute("LOCALE_COUNTRY", Locale.getDefault().getCountry());
            this.trackDeviceAndUserAttribute("LOCALE_COUNTRY_DISPLAY", Locale.getDefault().getDisplayCountry());
            this.trackDeviceAndUserAttribute("LOCALE_LANGUAGE", Locale.getDefault().getLanguage());
            this.trackDeviceAndUserAttribute("LOCALE_LANGUAGE_DISPLAY", Locale.getDefault().getDisplayLanguage());
            this.trackDeviceAndUserAttribute("LOCALE_DISPLAY", Locale.getDefault().getDisplayName());
            this.trackDeviceAndUserAttribute("LOCALE_COUNTRY_ ISO3", Locale.getDefault().getISO3Country());
            this.trackDeviceAndUserAttribute("LOCALE_LANGUAGE_ISO3", Locale.getDefault().getISO3Language());
        }
        catch (Exception e) {
            Logger.e("Core_MoEDispatcher trackDeviceLocale", e);
        }
    }

    private void trackDeviceAndUserAttribute(String attrName, String attrValue) {
        try {
            JSONObject attribute = new JSONObject();
            attribute.put(attrName, (Object)attrValue);
            this.setUserAttribute(attribute);
        }
        catch (Exception e) {
            Logger.e("Core_MoEDispatcher trackDeviceAndUserAttribute() ", e);
        }
    }

    public void logoutUser(boolean isForcedLogout) {
        try {
            Bundle extras = new Bundle();
            extras.putBoolean("IS_FORCE_LOGOUT", isForcedLogout);
            TaskManager.getInstance().addTaskToQueue(new MoEWorkerTask(this.context, "LOGOUT", extras));
        }
        catch (Exception e) {
            Logger.e("Core_MoEDispatcher logoutUser() ", e);
        }
    }

    private void trackChangedUniqueId() {
        if (this.uniqueIdAttribute != null) {
            this.setUserAttribute(this.uniqueIdAttribute);
            this.uniqueIdAttribute = null;
            this.shouldTrackUniqueId = false;
        }
    }

    public void setAlias(JSONObject aliasJSON) {
        if (!RemoteConfig.getConfig().isAppEnabled) {
            return;
        }
        TaskManager.getInstance().addTaskToQueue(new SetAliasTask(this.context, aliasJSON));
    }

    public void setDeviceAttribute(JSONObject deviceAttribute) {
        TaskManager.getInstance().addTaskToQueue(new SetDeviceAttributeTask(this.context, deviceAttribute));
    }

    private void schedulePeriodicFlushIfRequired() {
        try {
            Logger.v("Core_MoEDispatcher schedulePeriodicFlushIfRequired() : Will try to schedule periodic flush if enabled.");
            if (RemoteConfig.getConfig().isPeriodicFlushEnabled && SdkConfig.getConfig().isPeriodicFlushEnabled) {
                Runnable syncRunnable = new Runnable(){

                    @Override
                    public void run() {
                        Logger.v("Core_MoEDispatcher schedulePeriodicFlushIfRequired() inside runnable, will sync now");
                        MoEDispatcher.this.sendInteractionData();
                    }
                };
                long timeDelay = RemoteConfig.getConfig().periodicFlushTime;
                if (SdkConfig.getConfig().flushInterval > timeDelay) {
                    timeDelay = SdkConfig.getConfig().flushInterval;
                }
                Logger.v("Core_MoEDispatcher schedulePeriodicFlushIfRequired() scheduling periodic sync");
                this.scheduler = Executors.newScheduledThreadPool(1);
                this.scheduler.scheduleWithFixedDelay(syncRunnable, timeDelay, timeDelay, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            Logger.e("Core_MoEDispatcher schedulePeriodicFlushIfRequired() ", e);
        }
    }

    private void shutDownPeriodicFlush() {
        try {
            if (RemoteConfig.getConfig().isPeriodicFlushEnabled && SdkConfig.getConfig().isPeriodicFlushEnabled && this.scheduler != null) {
                Logger.v("Core_MoEDispatcher shutDownPeriodicFlush() shutting down periodic flush");
                this.scheduler.shutdownNow();
            }
        }
        catch (Exception e) {
            Logger.e("Core_MoEDispatcher shutDownPeriodicFlush() ", e);
        }
    }

    public void onAppOpen() {
        if (!RemoteConfig.getConfig().isAppEnabled) {
            return;
        }
        try {
            Logger.v("Core_MoEDispatcher onAppOpen(): Application coming to foreground.");
            TaskManager.getInstance().addTaskToQueue(new AppOpenTask(this.context));
            this.syncConfigIfRequired();
            this.updateFeatureConfigForOptOutIfRequired();
            this.schedulePeriodicFlushIfRequired();
            if (ConfigurationProvider.getInstance(this.context).isDebugLogEnabled()) {
                SdkConfig.getConfig().logConfig.isEnabledForSignedBuild = true;
                SdkConfig.getConfig().logConfig.level = 5;
            }
            this.updatePushService();
        }
        catch (Exception e) {
            Logger.e("Core_MoEDispatcher onAppOpen() ", e);
        }
    }

    void updateFeatureConfigForOptOutIfRequired() {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.context);
        if (provider.isDataTrackingOptedOut()) {
            SdkConfig.getConfig().trackingOptOut.setGaidOptedOut(true);
            SdkConfig.getConfig().trackingOptOut.setAndroidIdOptedOut(true);
            SdkConfig.getConfig().isLocationTrackingOptedOut = true;
            SdkConfig.getConfig().isGeofenceTrackingOptedOut = true;
            SdkConfig.getConfig().trackingOptOut.setDeviceAttributeOptedOut(true);
            SdkConfig.getConfig().isLocationServiceEnabled = false;
        }
        if (provider.isPushNotificationOptedOut()) {
            Logger.v("Core_MoEDispatcher updateFeatureConfigForOptOutIfRequired() : Push opted out clearing Push Token.");
            provider.clearPushToken();
        }
    }

    void notifyLogoutCompleteListener() {
        Logger.v("Core_MoEDispatcher notifyLogoutCompleteListener() : Notifying listeners");
        for (OnLogoutCompleteListener listener : MoECallbacks.getInstance().getLogoutListenerList()) {
            try {
                listener.logoutComplete();
            }
            catch (Exception e) {
                Logger.e("Core_MoEDispatcher notifyLogoutCompleteListener() : ", e);
            }
        }
    }

    public void onAppClose() {
        if (!RemoteConfig.getConfig().isAppEnabled) {
            return;
        }
        Logger.v("Core_MoEDispatcher onAppClose(): Application going to background.");
        DataManager.getInstance().scheduleDataSending(this.context);
        this.notifyOnAppBackground();
        this.getDeviceAddManager().retryDeviceRegistrationIfRequired(this.context);
        this.shutDownPeriodicFlush();
        this.trackAppExit();
        AnalyticsHelper.getInstance(this.context).onAppClose(this.context);
        InAppManager.getInstance().onAppClose(this.context);
        MoEDTManager.getInstance().scheduleBackgroundSync(this.context);
        ConfigurationProvider.getInstance(this.context).saveSentScreenNames(ConfigurationCache.getInstance().getSentScreenNames());
        PushAmpManager.getInstance().scheduleServerSync(this.context);
        GeoManager.getInstance().scheduleBackgroundSync(this.context);
    }

    private void notifyOnAppBackground() {
        for (OnAppBackgroundListener onAppBackgroundListener : MoECallbacks.getInstance().getBackgroundListenerList()) {
            try {
                onAppBackgroundListener.goingToBackground();
            }
            catch (Exception e) {
                Logger.e("Core_MoEDispatcher notifyOnAppBackground() : ", e);
            }
        }
        for (AppBackgroundListener appBackgroundListener : MoECallbacks.getInstance().getAppBackgroundListeners()) {
            try {
                appBackgroundListener.onAppBackground(this.context);
            }
            catch (Exception e) {
                Logger.e("Core_MoEDispatcher notifyOnAppBackground() : ", e);
            }
        }
    }

    private void trackAppExit() {
        MoEHelper.getInstance(this.context).trackEvent("MOE_APP_EXIT", new Properties());
    }

    public DeviceAddManager getDeviceAddManager() {
        if (this.deviceAddManager == null) {
            this.deviceAddManager = new DeviceAddManager();
        }
        return this.deviceAddManager;
    }

    public void showInAppFromPush(Bundle bundle) {
        try {
            InAppManager.getInstance().showInAppFromPush(this.context, bundle);
        }
        catch (Exception e) {
            Logger.e("Core_MoEDispatcher showInAppFromPush() : ", e);
        }
    }

    private void updatePushService() {
        if (!MiPushManager.getInstance().hasMiPushModule() && PushKitManager.getInstance().hasPushKitModule()) {
            ConfigurationProvider.getInstance(this.context).savePushService("FCM");
        }
    }
}

