/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import com.moengage.core.ISO8601Utils;
import com.moengage.core.Logger;
import com.moengage.core.model.TrafficSource;
import com.moengage.core.model.UserSession;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class MoECoreEvaluator {
    private static final String TAG = "Core_MoECoreEvaluator";

    public boolean isValidUniqueId(List<String> uniqueIdRegexList, String trackedUniqueId) {
        try {
            if (uniqueIdRegexList == null) {
                return true;
            }
            for (String regex : uniqueIdRegexList) {
                if (!Pattern.matches(regex, trackedUniqueId)) continue;
                return false;
            }
        }
        catch (Exception e) {
            Logger.e("Core_MoECoreEvaluator isValidUniqueId() : Exception: ", e);
        }
        return true;
    }

    public boolean shouldTrackScreenName(String screenName, List<String> optedOutScreenNames) {
        if (optedOutScreenNames == null || optedOutScreenNames.isEmpty()) {
            return true;
        }
        return !optedOutScreenNames.contains(screenName);
    }

    public boolean hasSessionExpired(long lastActiveTime, long sessionInActivityDuration, long currentTime) {
        return lastActiveTime + sessionInActivityDuration < currentTime;
    }

    public boolean hasSourceChanged(TrafficSource savedSource, TrafficSource currentSource) {
        if (TrafficSource.isEmpty(savedSource) && TrafficSource.isEmpty(currentSource)) {
            return false;
        }
        if (TrafficSource.isEmpty(savedSource) && !TrafficSource.isEmpty(currentSource)) {
            return true;
        }
        if (!TrafficSource.isEmpty(savedSource) && TrafficSource.isEmpty(currentSource)) {
            return false;
        }
        return !savedSource.equals(currentSource);
    }

    public boolean isInteractiveEvent(String dataPointString) {
        try {
            JSONObject dataPointJson = new JSONObject(dataPointString);
            if (!dataPointJson.has("N_I_E")) {
                return true;
            }
            int isInteractive = dataPointJson.getInt("N_I_E");
            return isInteractive == 0;
        }
        catch (Exception e) {
            Logger.e("Core_MoECoreEvaluator isInteractiveEvent() : Exception: ", e);
            return true;
        }
    }

    public boolean canShowCampaignNow(long startTime, long endTime, int currentHour, int currentMinutes) {
        if (endTime == -1L || startTime == -1L || startTime == 0L && endTime == 0L || endTime == startTime) {
            return false;
        }
        int dndStartTimeHours = 0;
        int dndStartTimeMinutes = 0;
        if (startTime != 0L) {
            dndStartTimeHours = (int)startTime / 100;
            dndStartTimeMinutes = (int)startTime % 100;
        }
        int dndStopTimeHours = 0;
        int dndStopTimeMinutes = 0;
        if (endTime != 0L) {
            dndStopTimeHours = (int)endTime / 100;
            dndStopTimeMinutes = (int)endTime % 100;
        }
        if (dndStartTimeHours > dndStopTimeHours) {
            if (dndStartTimeHours < currentHour || dndStopTimeHours > currentHour) {
                return true;
            }
            if (dndStartTimeHours == currentHour) {
                return currentMinutes >= dndStartTimeMinutes;
            }
            if (dndStopTimeHours == currentHour) {
                return currentMinutes <= dndStopTimeMinutes;
            }
        } else if (dndStartTimeHours < dndStopTimeHours) {
            if (currentHour > dndStartTimeHours && currentHour < dndStopTimeHours) {
                return true;
            }
            if (dndStartTimeHours == currentHour) {
                return currentMinutes >= dndStartTimeMinutes;
            }
            if (dndStopTimeHours == currentHour) {
                return currentMinutes <= dndStopTimeMinutes;
            }
        } else if (dndStartTimeHours == dndStopTimeHours) {
            return currentHour == dndStartTimeHours && currentMinutes >= dndStartTimeMinutes && currentMinutes <= dndStopTimeMinutes;
        }
        return false;
    }

    public boolean canUpdateSourceInCurrentSession(UserSession userSession, long currentTime) {
        if (userSession == null) {
            return false;
        }
        if (!TrafficSource.isEmpty(userSession.trafficSource)) {
            return false;
        }
        long sessionStartTime = ISO8601Utils.parse(userSession.startTime).getTime();
        return (currentTime - sessionStartTime) / 1000L <= 3L;
    }
}

