/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDTManager;
import com.moengage.core.MoEUtils;
import com.moengage.core.Properties;
import com.moengage.core.SdkConfig;
import com.moengage.core.cards.CardManager;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.internal.AdvertisingIdClient;
import com.moengage.core.internal.inapp.InAppManager;
import com.moengage.core.internal.location.GeoManager;
import com.moengage.core.internal.pushamp.PushAmpManager;
import com.moengage.core.mipush.MiPushManager;
import com.moengage.push.PushManager;
import com.moengage.push.hms.puskit.PushKitManager;

class AppOpenTask
extends SDKTask {
    private static final String TAG = "Core_AppOpenTask";

    public AppOpenTask(Context context) {
        super(context);
    }

    @Override
    public TaskResult execute() {
        try {
            MoEHelper.getInstance(this.context).trackEvent("EVENT_ACTION_ACTIVITY_START", new Properties());
            GeoManager.getInstance().updateFenceAndLocation(this.context);
            InAppManager.getInstance().syncInAppsIfRequired(this.context);
            PushAmpManager.getInstance().forceServerSync(this.context, true);
            PushManager.getInstance().registerForPush(this.context);
            PushManager.getInstance().onAppOpen(this.context);
            MoEDTManager.getInstance().forceSyncDeviceTriggers(this.context);
            MiPushManager.getInstance().initMiPush(this.context);
            PushKitManager.getInstance().onAppOpen(this.context);
            CardManager.getInstance().onAppOpen(this.context);
            MoEDAO.getInstance(this.context).removeExpiredData();
            this.checkGoogleAdvertisementIDAndUpdate();
        }
        catch (Exception e) {
            Logger.e("Core_AppOpenTask execute() : ", e);
        }
        return this.taskResult;
    }

    @Override
    public String getTaskTag() {
        return "APP_OPEN";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }

    private void checkGoogleAdvertisementIDAndUpdate() {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.context);
        if (SdkConfig.getConfig().trackingOptOut.isGaidOptedOut()) {
            Logger.i("Core_AppOpenTask : Opted out of GAID Collection");
            return;
        }
        String storedGAID = provider.getStoredGAID();
        int storedISLAT = provider.getStoredISLAT();
        AdvertisingIdClient.AdInfo adInfo = MoEUtils.getAdvertisementInfo(this.context);
        if (adInfo == null) {
            return;
        }
        if (!(MoEUtils.isEmptyString(adInfo.getId()) || !MoEUtils.isEmptyString(storedGAID) && adInfo.getId().equals(storedGAID))) {
            MoEHelper.getInstance(this.context).setUserAttribute("MOE_GAID", adInfo.getId());
            provider.storeGAID(adInfo.getId());
        }
        if (adInfo.isLimitAdTrackingEnabled() != storedISLAT) {
            MoEHelper.getInstance(this.context).setUserAttribute("MOE_ISLAT", Integer.toString(adInfo.isLimitAdTrackingEnabled()));
            provider.storeISLAT(adInfo.isLimitAdTrackingEnabled());
        }
    }
}

