/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.app.Activity;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.Logger;
import com.moengage.core.MoECoreEvaluator;
import com.moengage.core.MoEUtils;
import com.moengage.core.SdkConfig;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.internal.analytics.AnalyticsHelper;
import java.util.Set;

class ActivityStartTask
extends SDKTask {
    private static final String TAG = "Core_ActivityStartTask";
    private Activity activity;

    ActivityStartTask(Activity activity) {
        super(activity.getApplicationContext());
        this.activity = activity;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("Core_ActivityStartTask started execution");
            String activityName = this.activity.getClass().getName();
            Logger.v("ActivityLifecycleStart : " + activityName + " started");
            AnalyticsHelper.getInstance(this.context).onActivityStart(this.activity);
            this.trackActivityIfRequired(activityName);
            this.taskResult.setIsSuccess(true);
            Logger.v("Core_ActivityStartTask completed execution");
        }
        catch (Exception e) {
            Logger.e("Core_ActivityStartTask execute() : Exception: ", e);
        }
        return this.taskResult;
    }

    @Override
    public String getTaskTag() {
        return "START_ACTIVITY";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }

    private boolean isActivityTracked(String activityName) {
        try {
            Set<String> trackedScreen = ConfigurationCache.getInstance().getSentScreenNames();
            return trackedScreen != null && trackedScreen.contains(activityName);
        }
        catch (Exception e) {
            Logger.e("Core_ActivityStartTask isActivityTracked() : ", e);
            return false;
        }
    }

    private void trackActivityIfRequired(String activityName) {
        if (this.isActivityTracked(activityName)) {
            return;
        }
        MoECoreEvaluator evaluator = new MoECoreEvaluator();
        if (evaluator.shouldTrackScreenName(activityName, SdkConfig.getConfig().activityTrackingOptOutList)) {
            MoEUtils.trackActivityStates("EVENT_ACTION_ACTIVITY_START", activityName, this.context);
            ConfigurationCache.getInstance().addScreenToSentList(activityName);
        }
    }
}

