/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.RemoteConfig;
import com.moengage.core.RemoteConfigDefault;
import com.moengage.core.RestUtils;
import com.moengage.core.SdkConfig;
import com.moengage.core.exceptions.SDKNotInitializedException;
import com.moengage.core.internal.security.SecretKeyType;
import com.moengage.core.model.LogRequest;
import com.moengage.core.model.RemoteLog;
import com.moengage.core.rest.RequestBuilder;
import com.moengage.core.rest.Response;
import com.moengage.core.rest.RestClient;
import com.moengage.core.rest.exceptions.UTF8EncodingException;
import com.moengage.core.utils.JsonBuilder;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class APIManager {
    private static final String REQUEST_ATTR_LOG_TYPE = "log_type";
    private static final String REQUEST_ATTR_SENT_TIME = "sent_time";
    private static final String REQUEST_ATTR_LAKE_FIELDS = "lake_fields";
    private static final String REQUEST_ATTR_MESSAGE = "msg";
    private static final String REQUEST_ATTR_STACK_TRACE = "trace";
    private static final String REQUEST_ATTR_PLATFORM = "platform";
    private static final String REQUEST_ATTR_LOGS = "logs";
    private static final String LOG_ENDPOINT = "v1/sdk_logging/android";

    private APIManager() {
    }

    @Nullable
    public static Response deviceTriggerSyncRequest(Context context, String path, HashMap<String, String> paramsMap, JSONObject requestBody) {
        try {
            if (!RemoteConfig.getConfig().isRealTimeTriggerEnabled || !RemoteConfig.getConfig().isAppEnabled || MoEUtils.isEmptyString(SdkConfig.getConfig().appId)) {
                return null;
            }
            Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath(path);
            RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestBuilder.RequestType.POST, MoEUtils.getAppId());
            JsonBuilder queryParams = RestUtils.getDefaultParams(context);
            queryParams.putString("device_tz", TimeZone.getDefault().getID());
            if (paramsMap != null) {
                for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
                    queryParams.putString(entry.getKey(), entry.getValue());
                }
            }
            if (requestBody == null) {
                requestBody = new JSONObject();
            }
            requestBody.put("query_params", (Object)queryParams.build());
            requestBuilder.addBody(requestBody);
            RestClient restClient = new RestClient(requestBuilder.build());
            return restClient.executeRequest();
        }
        catch (Exception e) {
            Logger.e("MoERestClient: deviceTriggerSyncRequest() : Exception ", e);
            return null;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public static Response reportAdd(String appId, String path, String requestId, JSONObject body) throws IOException, SDKNotInitializedException, InvalidKeyException {
        Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath(path);
        RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestBuilder.RequestType.POST, appId).addHeader("MOE-REQUEST-ID", requestId).addBody(body);
        RestClient restClient = new RestClient(requestBuilder.build());
        return restClient.executeRequest();
    }

    @Nullable
    public static Response configApi(String appId, JSONObject requestBody) throws IOException, SDKNotInitializedException, InvalidKeyException {
        Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath("v3/sdkconfig/android/").appendEncodedPath(appId);
        RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestBuilder.RequestType.POST, appId).addBody(requestBody);
        if (SdkConfig.getConfig().isEncryptionEnabled) {
            requestBuilder.addHeader("MOE-PAYLOAD-ENC-KEY-TYPE", SecretKeyType.DEFAULT.name().toLowerCase()).enableEncryption(RemoteConfigDefault.DEFAULT_DATA_ENCRYPTION_KEY);
        }
        RestClient restClient = new RestClient(requestBuilder.build());
        return restClient.executeRequest();
    }

    public static Response deviceAdd(String appId, JSONObject requestBody, String requestId) throws SDKNotInitializedException, UTF8EncodingException, InvalidKeyException {
        Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath("v2/sdk/device").appendPath(appId);
        RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestBuilder.RequestType.POST, appId).addBody(requestBody).addHeader("MOE-REQUEST-ID", requestId);
        RestClient restClient = new RestClient(requestBuilder.build());
        return restClient.executeRequest();
    }

    public static void sendLog(LogRequest logRequest) {
        try {
            Uri.Builder uriBuilder = RestUtils.getBaseUriBuilder().appendEncodedPath(LOG_ENDPOINT).appendEncodedPath(logRequest.appId);
            RequestBuilder requestBuilder = RestUtils.getBaseRequestBuilder(uriBuilder.build(), RequestBuilder.RequestType.POST, logRequest.appId).disableRequestLogging();
            requestBuilder.addBody(APIManager.logRequestBody(logRequest));
            RestClient restClient = new RestClient(requestBuilder.build());
            restClient.executeRequest();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static JSONObject logRequestBody(LogRequest logRequest) throws JSONException {
        JsonBuilder bodyBuilder = new JsonBuilder();
        bodyBuilder.putJsonObject("query_params", logRequest.defaultParams.putString(REQUEST_ATTR_PLATFORM, logRequest.platform).build());
        JSONArray logArray = new JSONArray();
        for (RemoteLog log : logRequest.remoteLogs) {
            JSONObject logJson = APIManager.remoteLogToJson(log);
            if (logJson == null || logJson.length() == 0) continue;
            logArray.put((Object)logJson);
        }
        bodyBuilder.putJsonArray(REQUEST_ATTR_LOGS, logArray);
        return bodyBuilder.build();
    }

    @Nullable
    private static JSONObject remoteLogToJson(RemoteLog log) {
        try {
            JsonBuilder lakeBuilder = new JsonBuilder();
            lakeBuilder.putString(REQUEST_ATTR_MESSAGE, log.logMessage.message);
            if (!MoEUtils.isEmptyString(log.logMessage.errorString)) {
                lakeBuilder.putString(REQUEST_ATTR_STACK_TRACE, log.logMessage.errorString);
            }
            JsonBuilder logBuilder = new JsonBuilder();
            logBuilder.putString(REQUEST_ATTR_LOG_TYPE, log.logType).putString(REQUEST_ATTR_SENT_TIME, log.time).putJsonObject(REQUEST_ATTR_LAKE_FIELDS, lakeBuilder.build());
            return logBuilder.build();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

