/*
 * Decompiled with CFR 0.152.
 */
package com.moe.pushlibrary.activities;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.fragment.app.FragmentActivity;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.R;

public class MoEActivity
extends FragmentActivity {
    private static final String TAG = "Core_MoEActivity";

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_moe_rich_landing);
        WebView webView = (WebView)this.findViewById(R.id.moeRichLandingWebView);
        Bundle extras = this.getIntent().getExtras();
        String url = null;
        if (extras != null && extras.containsKey("gcm_webUrl")) {
            url = extras.getString("gcm_webUrl");
        }
        if (MoEUtils.isEmptyString(url)) {
            Logger.v("Core_MoEActivity onCreate() : Rich landing url is empty, finishing activity.");
            this.finish();
            return;
        }
        final boolean isEmbedded = extras.getBoolean("isEmbeddedWebView", false);
        Logger.v("Core_MoEActivity onCreate() : Is embedded web view? " + isEmbedded);
        webView.loadUrl(url);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setBuiltInZoomControls(true);
        webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                try {
                    Logger.v("Core_MoEActivity shouldOverrideUrlLoading() : Url: " + url);
                    Uri uri = Uri.parse((String)url);
                    String scheme = uri.getScheme();
                    if (isEmbedded && ("http".equals(scheme) || "https".equals(scheme))) {
                        return false;
                    }
                    Intent intent = new Intent("android.intent.action.VIEW", uri);
                    MoEActivity.this.startActivity(intent);
                    return true;
                }
                catch (Exception e) {
                    Logger.e("Core_MoEActivity shouldOverrideUrlLoading() : ", e);
                    return false;
                }
            }
        });
    }
}

