/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.utils;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEUtils;
import com.moengage.core.rest.Response;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;

/**
 * @author Umang Chamaria
 */
public class ApiUtility {
  private static final String TAG = MoEConstants.MODULE_TAG + "ApiUtility";

  @Nullable public static List<String> jsonArrayToStringList(JSONArray jsonArray) {
    try {
      if (jsonArray == null) return null;
      List<String> stringList = new ArrayList<>();
      for (int i = 0; i< jsonArray.length(); i++){
        String s = jsonArray.getString(i);
        if (!TextUtils.isEmpty(s)) {
          stringList.add(s);
        }
      }
      return stringList;
    } catch (Exception e) {
      Logger.e( TAG + " jsonArrayToStringList() : Exception ", e);
    }
    return null;
  }


  public static boolean isSuccessfulResponse(Response response) {
    if (response == null) return false;
    return response.responseCode == 200;
  }

  public static Set<String> jsonArrayToStringSet(JSONArray jsonArray){
    Set<String> stringSet = new HashSet<>();
    try {
      if (jsonArray == null) return stringSet;
      for (int i = 0; i < jsonArray.length(); i++) {
        if (!MoEUtils.isEmptyString(jsonArray.getString(i))) stringSet.add(jsonArray.getString(i));
      }
      return stringSet;
    }catch (Exception e){
      Logger.e( TAG + " jsonArrayToStringSet() : Exception: ", e);
    }
    return stringSet;
  }

  public static <T> JSONArray listToJsonArray(List<T> list){
    JSONArray jsonArray = new JSONArray();
    for (T item: list){
      jsonArray.put(item);
    }
    return jsonArray;
  }

  public static <T> JSONArray setToJsonArray(Set<T> set) {
    JSONArray jsonArray = new JSONArray();
    for (T item : set) {
      jsonArray.put(item);
    }
    return jsonArray;
  }
}
