/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.internal.storage.repository.local

import android.content.Context
import com.moengage.core.ConfigurationProvider
import com.moengage.core.SdkConfig
import com.moengage.core.internal.storage.*
import com.moengage.core.internal.storage.StorageProvider.getSharedPreference
import com.moengage.core.internal.storage.preference.DEVICE_REGISTRATION_STATE
import com.moengage.core.internal.storage.preference.KEY_DEVICE_REGISTRATION_STATE
import com.moengage.core.internal.storage.preference.KEY_LAST_CONFIG_SYNC_TIME
import com.moengage.core.internal.storage.preference.LAST_CONFIG_SYNC_TIME
import com.moengage.core.model.PushTokens

/**
 * @author Umang Chamaria
 * Date: 2020/11/05
 */
class LocalRepositoryImpl(private val context: Context, private val sdkConfig: SdkConfig) :
    LocalRepository {

    override fun getConfigSyncTime(): Long {
        return StorageProvider.getSharedPreference(context, sdkConfig).getLong(
            KEY_LAST_CONFIG_SYNC_TIME, LAST_CONFIG_SYNC_TIME
        )
    }

    override fun updateConfigApiSyncTime(time: Long) {
        StorageProvider.getSharedPreference(context, sdkConfig)
            .putLong(KEY_LAST_CONFIG_SYNC_TIME, time)
    }

    override fun getPushTokens(): PushTokens {
        val sharePrefHelper = getSharedPreference(context, SdkConfig.getConfig())
        return PushTokens(
            sharePrefHelper.getString(ConfigurationProvider.FCM_PUSH_TOKEN, ""),
            sharePrefHelper.getString(ConfigurationProvider.OEM_PUSH_TOKEN, "")
        )
    }

    override fun isDeviceRegistered(): Boolean {
        return getSharedPreference(
            context,
            SdkConfig.getConfig()
        ).getBoolean(KEY_DEVICE_REGISTRATION_STATE, DEVICE_REGISTRATION_STATE)
    }

    override fun setDeviceRegistrationState(state: Boolean) {
        getSharedPreference(
            context,
            SdkConfig.getConfig()
        ).putBoolean(KEY_DEVICE_REGISTRATION_STATE, state)
    }
}