/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.internal.storage.preference

import android.content.Context
import android.content.SharedPreferences
import androidx.annotation.RestrictTo
import com.moengage.core.SdkConfig

/**
 * @author Umang Chamaria
 * Date: 2020/11/03
 */
public class SharedPrefHelper(private val context: Context, private val config: SdkConfig) {

    private val preferences: SharedPreferences =
        context.getSharedPreferences(DEFAULT_PREF_NAME, Context.MODE_PRIVATE)

    public fun putString(key: String, value: String) {
        preferences.edit().putString(key, value).apply()
    }

    public fun getString(key: String, defaultValue: String): String? {
        return preferences.getString(key, defaultValue)
    }

    public fun putInt(key: String, value: Int) {
        preferences.edit().putInt(key, value).apply()
    }

    public fun getInt(key: String, defaultValue: Int): Int {
        return preferences.getInt(key, defaultValue)
    }

    public fun putLong(key: String, value: Long) {
        preferences.edit().putLong(key, value).apply()
    }

    public fun getLong(key: String, defaultValue: Long): Long {
        return preferences.getLong(key, defaultValue)
    }

    public fun putBoolean(key: String, value: Boolean) {
        preferences.edit().putBoolean(key, value).apply()
    }

    public fun getBoolean(key: String, defaultValue: Boolean): Boolean {
        return preferences.getBoolean(key, defaultValue)
    }


    public fun putStringSet(key: String, stringSet: Set<String>) {
        preferences.edit().putStringSet(key, stringSet).apply()
    }

    public fun getStringSet(key: String, defaultValue: Set<String>): Set<String>? {
        return preferences.getStringSet(key, defaultValue)
    }

    public fun removeKey(key: String) {
        preferences.edit().remove(key).apply()
    }

    @RestrictTo(RestrictTo.Scope.LIBRARY)
    public fun getPreference(): SharedPreferences {
        return preferences
    }
}

private const val DEFAULT_PREF_NAME = "pref_moe"
private const val SHARED_PREF_NAME = "pref_moe_"