/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.internal.storage.database.contract;

import android.content.Context;
import android.net.Uri;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moe.pushlibrary.providers.MoEDataContract.BaseColumns;

/**
 * @author Umang Chamaria
 * Date: 2020/11/05
 */
public class DataPointContract {

  interface DataPointColumns extends BaseColumns {

    String DETAILS = "details";

    int COLUMN_INDEX_DETAILS = 2;
    /**
     * PROJECTION showing Events TABLE
     */
    String[] PROJECTION = { _ID, GTIME, DETAILS };
  }

  public static final class DataPointEntity implements DataPointColumns {

    public static Uri getContentUri(Context context) {
      return Uri.parse("content://" + MoEDataContract.getAuthority(context) + "/datapoints");
    }

    /**
     * The MIME type of CONTENT_URIproviding a directory of
     * events.
     */
    public static final String CONTENT_TYPE = "vnd.android.cursor.dir/vnd.moe.datapoints";
    /**
     * The MIME type of a CONTENT_URIsub-directory of a single
     * event.
     */
    public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/vnd.moe.datapoint";

    /**
     * Utility class cannot be instantiated
     */
    private DataPointEntity() {
      // Intentionally made private
    }
  }
}
