/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.internal.reports;

import android.content.Context;
import android.os.Build;
import androidx.annotation.Nullable;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.RemoteConfig;
import com.moengage.core.SdkConfig;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.MoEJobParameters;

/**
 * Send report batches to the server.
 *
 * @author Umang Chamaria
 */
class SendInteractionDataTask extends SDKTask {
  @Nullable private final MoEJobParameters jobParameters;
  private final int attemptNumber;

  private final String TAG = MoEConstants.MODULE_TAG + "SendInteractionDataTask";

  SendInteractionDataTask(Context context) {
    this(context, null, DataManager.NO_RETRY);
  }

  SendInteractionDataTask(Context context, @Nullable MoEJobParameters jobParameters,
      int attemptNumber) {
    super(context);
    this.jobParameters = jobParameters;
    this.attemptNumber = attemptNumber;
  }

  @Override public TaskResult execute() {
    try {
      if (!RemoteConfig.getConfig().isAppEnabled) return null;
      Logger.v(TAG + " executing task");

      DataManager.getInstance().sendData(context, SdkConfig.getConfig().appId, attemptNumber);
      releaseJobLockIfRequired();
      Logger.v(TAG + " : completed task");
      return null;
    } catch (Exception e) {
      Logger.e(TAG + " : execute() ", e);
    }
    return null;
  }

  private void releaseJobLockIfRequired() {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP
        && jobParameters != null) {
      Logger.v(TAG + " releaseJobLockIfRequired() : Trying to release job lock.");
      jobParameters.jobCompleteListener.jobComplete(jobParameters);
    }
  }

  @Override public String getTaskTag() {
    return TAG_SEND_INTERACTION_DATA;
  }

  @Override public boolean isSynchronous() {
    return true;
  }
}
