/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.internal.logger;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.RestrictTo.Scope;
import com.moengage.core.LogLevel;

/**
 * @author Umang Chamaria
 * Date: 2020/10/01
 */
@RestrictTo(Scope.LIBRARY)
public class RemoteLogAdapter implements LogAdapter {

  private final @LogLevel int enabledLevel;
  private final boolean isLoggingEnabled;
  private final Context context;
  //private final List<RemoteLog> logList = Collections.synchronizedList(new ArrayList<RemoteLog>());
  private int cacheCount = 0;
  private final Object lock = new Object();
  //private final ExecutorService logService = Executors.newSingleThreadExecutor();

  public RemoteLogAdapter(Context context, boolean isLoggingEnabled, @LogLevel int logLevel) {
    this.isLoggingEnabled = isLoggingEnabled;
    this.enabledLevel = logLevel;
    this.context = context;
  }

  @Override public boolean isLoggable(int logLevel, String logTag) {
    //return isLoggingEnabled && enabledLevel >= logLevel;
    return false;
  }

  @Override public void log(@LogLevel final int logLevel, @Nullable final String tag,
      @NonNull final String message,
      @Nullable final Throwable throwable) {
    /*Runnable runnable = new Runnable() {
      @Override public void run() {
        cacheLog(logLevel, tag, message, throwable);
      }
    };
    logService.submit(runnable);*/
  }

  private void cacheLog(@LogLevel int logLevel, @Nullable String tag, @NonNull String message,
      @Nullable Throwable throwable) {
/*    synchronized (lock) {
      try {
        if (MoEUtils.isEmptyString(message)) return;
        logList.add(new RemoteLog(LogUtils.LOG_LEVEL_TO_LOG_TYPE_MAPPING.get(logLevel),
            MoEUtils.currentISOTime(),
            new LogMessage(message, LogUtils.getStackTraceString(throwable))));
        cacheCount++;
        if (cacheCount == 10) {
          flushLogs();
        }
      } catch (Exception ignored) {

      }
    }*/
  }

  @RestrictTo(Scope.LIBRARY)
  public void flushLogs(){
/*    List<RemoteLog> logs = new ArrayList<>(logList);
    cacheCount = 0;
    logList.clear();
    LogManager.getInstance().sendLog(context, logs);*/
  }
}
