/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.internal.logger;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.moengage.core.LogLevel;
import com.moengage.core.MoEUtils;
import com.moengage.core.MoEngage;
import com.moengage.core.SdkConfig;

/**
 * @author Umang Chamaria
 * Date: 10/05/20
 */
public class LogcatLogAdapter implements LogAdapter {

  @Override public boolean isLoggable(@LogLevel int logLevel, String logTag) {
    return (SdkConfig.getConfig().logConfig.isEnabledForSignedBuild || MoEngage.isDebugBuild())
        && SdkConfig.getConfig().logConfig.level >= logLevel;
  }

  @Override public void log(@LogLevel int logLevel, @Nullable String tag, @NonNull String message,
      @Nullable Throwable throwable) {
    try {
      if (MoEUtils.isEmptyString(message)) return;
      switch (logLevel) {
        case LogLevel.VERBOSE:
          logVerbose(tag, message);
          break;
        case LogLevel.DEBUG:
          logDebug(tag, message);
          break;
        case LogLevel.WARN:
          Log.w(tag, message);
          break;
        case LogLevel.ERROR:
          if (throwable != null) {
            Log.e(tag, message, throwable);
          } else {
            Log.e(tag, message);
          }
          break;
        case LogLevel.INFO:
          Log.i(tag, message);
          break;
        case LogLevel.NO_LOG:
          break;
      }
    } catch (Exception e) {

    }
  }

  private void logVerbose(String tag, String message) {
    if (message.length() > 4000) {
      Log.d(tag, message.substring(0, 4000));
      logVerbose(tag, message.substring(4000));
    } else {
      Log.d(tag, message);
    }
  }

  private void logDebug(String tag, String message) {
    if (message.length() > 4000) {
      Log.d(tag, message.substring(0, 4000));
      logDebug(tag, message.substring(4000));
    } else {
      Log.d(tag, message);
    }
  }
}
