/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.moengage.core.internal.logger

import android.content.Context
import androidx.annotation.RestrictTo
import com.moengage.core.Logger
import com.moengage.core.listeners.AppBackgroundListener
import com.moengage.core.model.RemoteLog

class LogManager private constructor(): AppBackgroundListener{

/*    init {
        MoECallbacks.getInstance().addAppBackgroundListener(this)
    }*/

    private val tag = "LogManager"

    private var logcatLogAdapter: LogcatLogAdapter? = null
//    private var remoteLogAdapter: RemoteLogAdapter? = null
//    private var fileLogAdapter: FileLogAdapter? = null

//    private val service = Executors.newSingleThreadExecutor()

    fun addLogcatAdapter() {
        synchronized(LogManager::class.java) {
            if (logcatLogAdapter == null) {
                logcatLogAdapter = LogcatLogAdapter()
            }
            Logger.addLogAdapter(logcatLogAdapter)
        }
    }

/*    fun addRemoteLogAdapter(context: Context?, config: RemoteConfig) {
        synchronized(LogManager::class.java) {
            if (remoteLogAdapter == null) {
                remoteLogAdapter = RemoteLogAdapter(
                    context, config.isRemoteLoggingEnabled,
                    config.logLevel
                )
            }
            Logger.addLogAdapter(remoteLogAdapter)
        }
    }*/

/*    fun addFileAdapter() {
        synchronized(LogManager::class.java) {
            if (fileLogAdapter == null) {
                fileLogAdapter = FileLogAdapter()
            }
            Logger.addLogAdapter(fileLogAdapter)
        }
    }*/

    override fun onAppBackground(context: Context?) {
        try {
/*            if (remoteLogAdapter != null) {
                remoteLogAdapter?.flushLogs()
            }*/
        } catch (e: Exception) {
            Logger.e("$tag onAppBackground() : ", e)
        }
    }

    @RestrictTo(RestrictTo.Scope.LIBRARY)
    fun sendLog(context: Context?, logs: List<RemoteLog?>) {
/*        if (logs.isEmpty()) return
        try {
            val runnable = Runnable {
                try {
                    APIManager.sendLog(LogRequest(RestUtils.getBaseRequest(context), logs))
                } catch (ignored: Exception) {
                }
            }
            service.submit(runnable)
        } catch (e: Exception) {
            Logger.e("$tag sendLog() : ", e)
        }*/
    }

    companion object {

        private var instance: LogManager? = null

        @JvmStatic
        fun getInstance(): LogManager {
            if (instance == null){
                synchronized(LogManager::class.java){
                    if (instance == null) instance = LogManager()
                }
            }
            return instance as LogManager
        }
    }
}