/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.internal.inapp;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.model.InAppV2Meta;
import com.moengage.core.model.InAppV3Meta;

public interface InAppHandler {

  /**
   * (non-Javadoc)
   * Sync in-apps from the server
   *
   * @param context Application Context
   */
  void showInAppIfRequired(Context context);

  /**
   * (non-Javadoc)
   * Registers a smart event and tries to show in-app for it
   *
   * @param context Application Context
   * @param event Event
   */
  void showTriggerInAppIfPossible(Context context, Event event);

  /**
   * (non-Javadoc)
   * Register to show in-apps in the activity.<br>
   *
   * @param currentActivity Activity instance in which in-apps needs to be shown.
   */
  void registerInAppManager(Activity currentActivity);

  /**
   * (non-Javadoc)
   * Unregister to show in-apps in the activity.<br>
   *
   * @param currentActivity Activity instance in which in-apps needs to be shown.
   */
  void unregisterInAppManager(Activity currentActivity);

  /**
   * Store the in-app check failure counter as an event
   *
   * @param context Application Context
   */
  void onAppClose(Context context);

  /**
   * Clear in-app related preference data.
   *
   * @param context Application Context
   */
  void onLogout(Context context);

  /**
   * Syncs the in-app meta API if required.
   *
   * @param context instance of {@link Context}
   */
  void syncInAppIfRequired(Context context);

  /**
   * Generate payload to migrate v2 campaign to v3.
   *
   * @param inAppV2Meta instance of {@link InAppV2Meta}
   * @return instance of {@link InAppV3Meta}
   */
  InAppV3Meta generateMetaForV2Campaign(InAppV2Meta inAppV2Meta);

  void showInAppFromPush(Context context, Bundle pushPayload);
}