/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.executor;

import android.content.Context;

/**
 * @author Umang Chamaria on 11/17/15.
 */
public abstract class SDKTask implements ITask {

  public static final String TAG_ACTIVITY_START = "START_ACTIVITY";
  protected static final String TAG_NOTIFICATION_CLICKED = "NOTIFICATION_CLICKED";
  protected static final String TAG_TRACK_EVENT = "TRACK_EVENT";
  public static final String TAG_DEVICE_ADD = "DEVICE_ADD";
  public static final String TAG_SEND_INTERACTION_DATA = "SEND_INTERACTION_DATA";
  public static final String TAG_SYNC_CONFIG_API = "SYNC_CONFIG";
  protected static final String TAG_SET_ALIAS = "SET_ALIAS";
  protected static final String TAG_SET_DEVICE_ATTRIBUTES = "SET_DEVICE_ATTRIBUTES";
  protected static final String TAG_MOE_WORKER_TASK = "MOE_WORKER_TASK";
  protected static final String TAG_MOE_PUSH_WORKER_TASK = "MOE_PUSH_WORKER_TASK";
  protected static final String TAG_CHECK_AND_SHOW_DT = "CHECK_AND_SHOW_DT";
  protected static final String TAG_DT_NETWORK_CALL_TASK = "DT_NETWORK_CALL_TASK";
  protected static final String TAG_DATA_TRACKING_OPT_OUT_TASK = "DATA_TRACKING_OPT_OUT_TASK";
  protected static final String TAG_CHECK_IN_APP_TASK = "CHECK_AND_SHOW_IN_APP_TASK";
  protected static final String TAG_CHECK_SELF_HANDLED_IN_APP_TASK = "CHECK_AND_SHOW_SELF_HANDLED_IN_APP_TASK";
  protected static final String TAG_CHECK_TRIGGER_BASED_IN_APP_TASK = "CHECK_AND_SHOW_TRIGGER_BASED_IN_APP_TASK";
  public static final String TAG_TRACK_ATTRIBUTE = "TRACK_ATTRIBUTE";
  public static final String TAG_PUSH_AMP_SERVER_SYNC_TASK = "PUSH_AMP_SERVER_SYNC_TASK";
  protected static final String TAG_TRACK_EVENT_SEGMENT = "TRACK_EVENT_SEGMENT";
  protected static final String TAG_TRACK_USER_ATTRIBUTE_SEGMENT = "TRACK_USER_ATTRIBUTE_SEGMENT";
  public static final String TAG_FETCH_IN_APP_META_TASK = "FETCH_IN_APP_META_TASK";
  protected static final String TAG_LOAD_CONFIGURATION_FROM_DISK = "LOAD_CONFIGURATION_FROM_DISK";
  protected static final String TAG_LOG_NOTIFICATION_CLICK = "LOG_NOTIFICATION_CLICK";

  protected static final String TAG_UPDATE_CAMPAIGN_STATE_TASK = "UPDATE_CAMPAIGN_STATE_TASK";
  protected static final String TAG_PREVIEW_INAPP_TASK = "PREVIEW_INAPP_TASK";
  public static final String TAG_BUILD_NUDGE_VIEW_TASK = "BUILD_NUDGE_VIEW_TASK";
  protected static final String TAG_UPLOAD_STATS_TASK = "UPLOAD_STATS_TASK";
  public static final String TAG_TEST_INAPP_TASK = "TEST_INAPP_TASK";
  public static final String TAG_LOGOUT_TASK = "LOGOUT_TASK";
  protected static final String TAG_INSTALL_UPDATE_TASK = "INSTALL_UPDATE_TASK";

  protected static final String TAG_TRACK_APP_STATUS = "TRACK_APP_STATUS";
  protected static final String TAG_GEOFENCE_FETCH = "GEOFENCE_FETCH";

  public static final String TAG_APP_CLOSE_TASK = "APP_CLOSE";
  public static final String TAG_APP_OPEN_TASK = "APP_OPEN";

  protected static final String TAG_BATCH_DATA_TASK = "BATCH_DATA";

  protected Context context;
  protected TaskResult taskResult;

  public SDKTask(Context context) {
    this.context = context;
    taskResult = new TaskResult();
    taskResult.setIsSuccess(false);
  }

  public TaskResult createTaskResult(Object payload, boolean taskState){
    taskResult.setPayload(payload);
    taskResult.setIsSuccess(taskState);
    return taskResult;
  }
}