/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.config

import android.Manifest.permission.READ_PHONE_STATE
import android.content.pm.PackageManager


/**
 * Create an instance of the tracking opt-out.
 *
 * @param isGaidOptedOut true if you don't want the SDK to track Google Advertising
 * Identifier, else false.
 * @param isAndroidIdOptedOut true if you don't want the SDK to track Android-id else false.
 * @param isCarrierOptedOut true if you don't want the SDK to track the Carrier Name else
 * false.
 * @param isDeviceAttributeOptedOut true if you don't want the SDK to track the device
 * attributes, else false.
 * @since 10.5.00
 * @author Umang Chamaria
 *
 *  Date: 2020/11/07
 */
class TrackingOptOutConfig(
    /**
     * If true Google Advertising Identifier would not be tracked by the SDK, default value false.
     */
    var isGaidOptedOut: Boolean,
    /**
     * If true Android-id would not be tracked by the SDK, default value false.
     */
    var isAndroidIdOptedOut: Boolean,
    /**
     * If true the Mobile Carrier name would not be tracked by the SDK, default value false.
     *
     * Note: Carrier name would only be tracked if the device has [PackageManager.FEATURE_TELEPHONY]
     * and the user has given [READ_PHONE_STATE] permission.
     */
    var isCarrierOptedOut: Boolean,
    /**
     * If true device attributes like Product name, Model Name, Height Width, etc are not
     * tracked, default value false.
     */
    var isDeviceAttributeOptedOut: Boolean
) {

    constructor() : this(false, false, false, false)

    override fun toString(): String {
        return "(isGaidTrackingOptedOut=$isGaidOptedOut, isAndroidIdTrackingOptedOut=$isAndroidIdOptedOut, isCarrierTrackingOptedOut=$isCarrierOptedOut, isDeviceAttributeTrackingOptedOut=$isDeviceAttributeOptedOut)"
    }


}