/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.config;

import androidx.annotation.Nullable;

/**
 * @author Umang Chamaria
 * Date: 09/07/20
 */
public class PushConfig {
  /**
   * Resource-id for push-notification large icon
   */
  public int largeIcon = -1;
  /**
   * Resource-id for push-notification small icon
   */
  public int smallIcon = -1;
  /**
   * Color for push-notification icon.
   */
  public int notificationColor = -1;
  /**
   * Notification done for android Oreo and below devices.
   */
  @Nullable public String tone;
  /**
   * If true show multiple notification in the drawer, else show single notification.
   */
  public boolean shouldShowMultiplePushInDrawer;
  /**
   * If true sdk will not synthesize back-stack for the notification's click action.
   */
  public boolean isBackStackBuilderOptedOut;
  /**
   * If true notification large icon will not be shown on Lollipop and above devices.
   */
  public boolean isLargeIconOptedOut;
  /**
   * If true sdk will try to register for Push Kit push token.
   */
  public boolean isPushKitRegistrationEnabled;
  /**
   * Time interval after which SDK will attempt to re-register for token, only used if SDK
   * registration is enabled.
   */
  public long tokenRetryInterval = 20;
  /**
   * Configuration Related to Mi Push
   */
  public MiPushConfig miPushConfig;
  /**
   * Configuration Related to Firebase Cloud Messaging
   */
  public FcmConfig fcm;

  public PushConfig(){
    miPushConfig = new MiPushConfig();
    fcm = new FcmConfig( true, "");
  }

  @Override public String toString() {
    return "{" +
        "largeIcon=" + largeIcon +
        ", smallIcon=" + smallIcon +
        ", notificationColor=" + notificationColor +
        ", tone='" + tone + '\'' +
        ", shouldShowMultiplePushInDrawer=" + shouldShowMultiplePushInDrawer +
        ", isBackStackBuilderOptedOut=" + isBackStackBuilderOptedOut +
        ", isLargeIconOptedOut=" + isLargeIconOptedOut +
        ", isPushKitRegistrationEnabled=" + isPushKitRegistrationEnabled +
        ", tokenRetryInterval=" + tokenRetryInterval +
        ", miPushConfig=" + miPushConfig +
        ", fcmConfig=" + fcm +
        '}';
  }
}
