/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.moengage.core.config


/**
 * Create an instance of Firebase Messaging Config.
 *
 * @param senderId sender-id/project id for the FCM project.<br></br>
 * **Sender id is a mandate when you are using Instant apps and MoEngage SDK is
 * * registering for push.**
 * @param isRegistrationEnabled true if you want the MoEngage SDK to register for Push else false.
 *
 * @author Umang Chamaria
 * Date: 2020/11/04
 */
public class FcmConfig(
    /**
     * If true sdk will try to register for FCM push token.
     */
    var isRegistrationEnabled: Boolean,
    /**
     * Sender-id also known as project id of the FCM project. Required only if instant app is
     * enabled.
     */
    var senderId: String?
) {
    /**
     * Create an instance of Firebase Messaging Config.
     *
     * @param isRegistrationEnabled true if you want the MoEngage SDK to register for Push else false.
     */
    constructor(isRegistrationEnabled: Boolean) : this(isRegistrationEnabled, "") {}

    override fun toString(): String {
        return "(senderId=$senderId, isRegistrationEnabled=$isRegistrationEnabled)"
    }
}