/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core.config;

import androidx.annotation.DrawableRes;
import com.moengage.core.MoEConstants;

/**
 * Card Configuration.
 *
 * @author Umang Chamaria
 * Date: 25/06/20
 */
public class CardConfig {
  /**
   * Resource id for the placeholder image for cards.
   */
  @DrawableRes public int cardPlaceHolderImage = -1;
  /**
   * Resource id for image indicating empty inbox.
   */
  @DrawableRes public int inboxEmptyImage = -1;
  /**
   * Date format shown on each card.
   */
  public String cardsDateFormat;

  /**
   * Create an instance of Card Configuration.
   *
   * @param cardPlaceHolderImage SDK shows a placeholder image in case the image download fails.
   * In case you want to change the placeholder image pass in the resource id of the image else
   * pass -1.
   * @param inboxEmptyImage SDK shows an image indicating inbox is empty. In case you
   * want to change the image pass in the resource id of the image else pass -1.
   * @param cardsDateFormat String for formatting date shown on each card.
   */
  public CardConfig(@DrawableRes int cardPlaceHolderImage, @DrawableRes int inboxEmptyImage,
      String cardsDateFormat) {
    this.cardPlaceHolderImage = cardPlaceHolderImage;
    this.inboxEmptyImage = inboxEmptyImage;
    this.cardsDateFormat = cardsDateFormat;
  }

  /**
   * Create an instance of Card Configuration.
   *
   * @param cardPlaceHolderImage SDK shows a placeholder image in case the image download fails.
   * In case you want to change the placeholder image pass in the resource id of the image else
   * pass -1.
   * @param inboxEmptyImage SDK shows an image indicating inbox is empty. In case you
   * want to change the image pass in the resource id of the image else pass -1.
   */
  public CardConfig(int cardPlaceHolderImage, int inboxEmptyImage) {
    this(cardPlaceHolderImage, inboxEmptyImage, MoEConstants.CARD_DEFAULT_DATE_FORMAT);
  }

  @Override public String toString() {
    return "{" +
        "cardPlaceHolderImage=" + cardPlaceHolderImage +
        ", inboxEmptyImage=" + inboxEmptyImage +
        ", cardsDateFormat='" + cardsDateFormat + '\'' +
        '}';
  }
}
