/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.moengage.core;

import android.app.IntentService;
import android.content.Intent;
import android.os.Bundle;
import com.moengage.core.internal.reports.DataManager;

/**
 * @author MoEngage (abhishek@moengage.com)
 * @version 5.0
 * @since 5.0
 */
// This Intent Service has the ability to do different kind of work based on the
// intent extra that is passed to this service
public class MoEWorker extends IntentService {

  private static final String TAG = MoEConstants.MODULE_TAG + "MoEWorker";

  public MoEWorker() {
    super("MoEWorker");
  }

  @Override protected void onHandleIntent(Intent intent) {
    try {
      if (null == intent) return;
      String action = intent.getAction();
      if (MoEUtils.isEmptyString(action)) return;
      if (DataManager.ACTION_DATA_SENDING.equals(action)) {
        Bundle extras = intent.getExtras();
        int attemptNumber = DataManager.NO_RETRY;
        if (extras != null) {
          attemptNumber = extras.getInt(DataManager.ATTEMPT_NUMBER,
              DataManager.NO_RETRY);
        }
        DataManager.getInstance().backgroundSync(getApplicationContext(), attemptNumber, null);
      } else {
        Logger.v(TAG + "Did not understand request");
      }
    } catch (Exception e) {
      Logger.e( TAG + " onHandleIntent() : ", e);
    }
  }
}
