/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.moengage.core;

/**
 * @author MoEngage (abhishek@moengage.com)
 * @version 1.0
 * @since 5.0
 */
public final class MoEConstants {

  private MoEConstants() {
    // Utility class cannot be instantiated
  }

  static final String EVENT_ACTIVITY_NAME = "ACTIVITY_NAME";

  public static final String ATTR_MOE_GAID = "MOE_GAID";

  static final String ATTR_IS_LAT = "MOE_ISLAT";
  /**
   *
   */
  static final String PREF_KEY_INSTALL_LOGGED = "pref_installed";
  /**
   * <b>Event Tracking</b>. Denotes that the activity is being started.
   */
  public static final String EVENT_ACTION_ACTIVITY_START = "EVENT_ACTION_ACTIVITY_START";
  /**
   * <b>Event Tracking</b>. Denotes that the event being logged is an user
   * attribute
   */
  public static final String EVENT_ACTION_USER_ATTRIBUTE = "EVENT_ACTION_USER_ATTRIBUTE";
  /**
   * <b>DEVICE ATTR Tracking</b>. Denotes that the event being logged is an user
   * attribute
   */
  static final String EVENT_ACTION_DEVICE_ATTRIBUTE = "EVENT_ACTION_DEVICE_ATTRIBUTE";
  /**
   * <b>Event Tracking</b>. Denotes that a coupon code was clicked
   */
  public static final String EVENT_ACTION_COUPON_CODE_COPY = "EVENT_ACTION_COUPON_CODE_COPY";
  /**
   * This is the GCM registration endpoint associated with the v1 API. This is
   * to be used with
   */
  static final String API_ENDPOINT_DEVICE_ADD = "v2/sdk/device";
  /**
   * API end point which needs to be used for sending interaction report. This
   * is to be used with
   */
  public static final String API_ENDPOINT_REPORT_ADD = "v2/sdk/report";
  /**
   * <b>API Param</b>. stating the last updated time stamp
   */
  public static final String PARAM_LAST_UPDATED = "last_updated";

  public static final String GENERIC_PARAM_KEY_NW_TYPE = "networkType";

  // API V2 generic params
  public static final String GENERIC_PARAM_V2_KEY_OS = "os";
  /**
   * Push token key for FCM
   */
  public static final String GENERIC_PARAM_V2_KEY_FCM_PUSH_ID = "push_id";
  public static final String GENERIC_PARAM_V2_KEY_APP_ID = "app_id";
  public static final String GENERIC_PARAM_V2_KEY_UUID = "unique_id";
  public static final String GENERIC_PARAM_V2_KEY_ANDROID_ID = "android_id";
  public static final String GENERIC_PARAM_V2_KEY_APP_VERSION = "app_ver";
  public static final String GENERIC_PARAM_V2_KEY_OS_VERSION = "os_ver";
  public static final String GENERIC_PARAM_V2_KEY_SDK_VERSION = "sdk_ver";
  public static final String GENERIC_PARAM_V2_KEY_TIMESTAMP = "device_ts";
  public static final String GENERIC_PARAM_V2_KEY_TIMEZONE = "device_tz";
  public static final String GENERIC_PARAM_V2_KEY_TIMEZONE_OFFSET = "device_tz_offset";
  public static final String GENERIC_PARAM_V2_KEY_MODEL = "model";
  public static final String GENERIC_PARAM_V2_KEY_APP_VERSION_NAME = "app_version_name";
  public static final String GENERIC_PARAM_V2_KEY_GAID = "moe_gaid";
  public static final String GENERIC_PARAM_V2_KEY_PUSH_SERVER = "moe_push_ser";
  public static final String GENERIC_PARAM_V2_KEY_INTEGRATION_TYPE = "integration_type";
  public static final String GENERIC_PARAM_V2_KEY_INTEGRATION_VERSION = "integration_version";
  /**
   * Push token for specific push services.
   */
  public static final String GENERIC_PARAM_V2_KEY_OEM_TOKEN = "mi_push_id";

  //generic params values
  public static final String GENERIC_PARAM_V2_VALUE_OS = "ANDROID";
  /**
   * Attribute stating the count of number of interaction points
   */
  public static final String ATTR_INTERACTION_VIEWS_COUNT = "viewsCount";
  /**
   * Attribute which holds all the interaction points
   */
  public static final String ATTR_INTERACTION_VIEWS_INFO = "viewsInfo";

  public static boolean dbUpdateRequired = true;

  public static final String API_ENDPOINT_CONFIG_API = "v3/sdkconfig/android/";

  public static final String API_ENDPOINT_INTEGRATION_VERIFICATION_DEVICE_REGISTRATION =
      "integration/register_device";

  public static final String API_ENDPOINT_INTEGRATION_VERIFICATION_REPORT_ADD =
      "integration/send_report_add_call";

  public static final String API_ENDPOINT_INTEGRATION_VERIFICATION_UNLINK_DEVICE =
      "integration/unregister_device";

  static final String LOGOUT_EVENT =  "MOE_LOGOUT";

  public static final String ATTR_SDK_IDENTIFIERS = "identifiers";

  public static final String SERVICE_TYPE_LOGOUT = "LOGOUT";

  public static final String SERVICE_TYPE_APP_UPDATE = "APP_UPDATE";

  public static final String SERVICE_LOGOUT_TYPE = "IS_FORCE_LOGOUT";

  public static final String ATTR_BATCH_ID = "bid";

  public static final String ATTR_SDK_META = "meta";

  public static final String REQUEST_ATTR_DEVICE_PREFERENCE = "dev_pref";

  public static final String REQUEST_ATTR_PUSH_PREFERENCE = "push_p";

  public static final String REQUEST_ATTR_IN_APP_PREFERENCE = "in_app_p";

  public static final String REQUEST_ATTR_REQUEST_TIME = "request_time";

  public static final String REQUEST_ATTR_DATA_TRACKING_PREFERENCE = "e_t_p";

  public static final String MOE_APP_EXIT_EVENT = "MOE_APP_EXIT";

  public static final String PUSH_REGISTRATION_ATTRIBUTE = "moe_p_reg";

  public static final String REQUEST_HEADER_REQUEST_ID = "MOE-REQUEST-ID";

  public static final String REQUEST_HEADER_APP_KEY = "MOE-APPKEY";

  public static final String REQUEST_ATTR_QUERY_PARAMS = "query_params";

  /**
   * USA Cluster
   */
  public static final String AUTHORITY_DATA_CENTER_01 = "apiv2.moengage.com";
  /**
   * EU Cluster
   */
  public static final String AUTHORITY_DATA_CENTER_02 = "apiv2eu.moengage.com";
  /**
   * India Cluster
   */
  public static final String AUTHORITY_DATA_CENTER_03 = "sdk-serv3.moengage.com";

  public static final String INTEGRATION_TYPE_SEGMENT = "segment";
  public static final String INTEGRATION_TYPE_XAMARIN = "xamarin";

  public static final String PUSH_SERVICE_FCM = "FCM";

  public static final String PUSH_SERVICE_MI_PUSH = "MI_PUSH";

  public static final String PUSH_SERVICE_PUSH_KIT = "HMS_PUSH";

  public static final String MANUFACTURER_XIAOMI = "Xiaomi";

  public static final String SHOW_NOTIFICATION = "SHOW_NOTIFICATION";

  public static final String PUSH_CAMPAIGN_MOE_ATTRIBUTES = "moe_cid_attr";

  public static final String MOE_CAMPAIGN_ID = "campaign_id";

  public static final String MOE_CAMPAIGN_NAME = "campaign_name";

  /**
   * Associated with event tracking for inapp message being shown
   */
  public static String EVENT_IN_APP_SHOWN = "MOE_IN_APP_SHOWN";
  /**
   * Associated with event tracking for in app message being clicked
   */
  public static String EVENT_IN_APP_CLICKED = "MOE_IN_APP_CLICKED";
  /**
   * Associated with event tracking when in-app is auto dismissed after the defined time
   */
  public static String EVENT_IN_APP_AUTO_DISMISS = "MOE_IN_APP_AUTO_DISMISS";
  /**
   * Associated with event tracking for in app message being explicitly closed
   * by use by clicking the close button
   */
  public static String EVENT_IN_APP_DISMISSED = "MOE_IN_APP_DISMISSED";

  public static String ATTRIBUTE_WIDGET_ID = "widget_id";

  public static String PUSH_EXTRA_INAPP_META = "moe_inapp";

  public static String PUSH_EXTRA_INAPP_LEGACY_META = "moe_inapp_cid";

  static long CONFIG_API_SYNC_DELAY = 3600000;

  public static String NOTIFICATION_DISMISSED = "MOE_NOTIFICATION_DISMISSED";

  public static String NOTIFICATION_SHOWN = "MOE_NOTIFICATION_SHOWN";
  public static String ATTRIBUTE_TOKEN_REGISTERED_MOE = "MoE";
  public static String ATTRIBUTE_TOKEN_REGISTERED_APP = "App";

  public static String MOE_CARD_DELIVERED = "MOE_CARD_DELIVERED";
  public static String MOE_CARD_IMPRESSION = "MOE_CARD_IMPRESSION";
  public static String MOE_CARD_CLICKED = "MOE_CARD_CLICKED";
  public static String MOE_CARD_DISMISSED = "MOE_CARD_DISMISSED";
  public static String MOE_INBOX_OPEN = "MOE_CARD_INBOX_CLICKED";

  public static String CARD_DEFAULT_DATE_FORMAT = "MMM dd, hh:mm a";

  public static final String ENCODED_BODY_KEY = "data";

  public static String ENCRYPTION_FAIL_MESSAGE = "Encryption failed!";

  public static int ENCRYPTION_FAIL = -1;

  public static final String HEADER_MOE_PAYLOAD_ENC_KEY_TYPE = "MOE-PAYLOAD-ENC-KEY-TYPE";

  public static final String MODULE_TAG = "Core_";

  public static final String EXTRA_IS_EMBEDDED_WEB_VIEW = "isEmbeddedWebView";

  public static final String PUSH_NOTIFICATION_TITLE = "gcm_title";
  public static final String PUSH_NOTIFICATION_MESSAGE = "gcm_alert";
  public static final String PUSH_NOTIFICATION_SUMMARY = "gcm_subtext";
  public static final String PUSH_NOTIFICATION_IMAGE_URL = "gcm_image_url";

}
