/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core;

import com.moengage.core.internal.logger.LogAdapter;
import com.moengage.core.internal.logger.LogPrinter;
import com.moengage.core.internal.logger.Printer;

/**
 * Sets the logging level for MoEngage SDK for DEBUG builds only.<br>
 * Log Levels :<br>
 *
 * @author Umang Chamaria
 * @since 7.0.00
 */
public class Logger {

  /**
   * Priority constant for the println method; use Logger.v.
   */
  @Deprecated
  public static final int VERBOSE = 5;
  /**
   * Priority constant for the println method; use Logger.d.
   */
  @Deprecated
  public static final int DEBUG = 4;
  /**
   * Priority constant for the println method; use Logger.w.
   */
  @Deprecated
  public static final int WARN = 3;
  /**
   * Priority constant for the println method; use Logger.e.
   */
  @Deprecated
  public static final int ERROR = 2;
  @Deprecated
  public static final int FATAL = 1;
  /**
   * Priority constant for the println method; use Logger.i.
   */
  @Deprecated
  public static final int INFO = 0;

  /**
   * Constant for no logs
   */
  public static final int NO_LOGS = -1;

  static int LOG_LEVEL = LogLevel.ERROR;

  //ERROR>WARN>INFO>DEBUG>V - LEVEL
  private Logger() {
  }

  public static void addLogAdapter(LogAdapter logAdapter){
    printer.addAdapter(logAdapter);
  }

  public static void removeLogAdapter(LogAdapter logAdapter){
    printer.removeAdapter(logAdapter);
  }

  public static void setTag(String tag){
    printer.setTag(tag);
  }

  private static Printer printer = new LogPrinter();

  /**
   * @param msg The message you would like logged.
   */
  public static void v(String msg) {
    printer.v(msg, null);
  }

  public static void v(String msg, Throwable tr) {
    printer.v(msg, tr);
  }

  /**
   * @param msg The message you would like logged.
   */
  public static void d(String msg) {
    printer.d(msg, null);
  }

  /**
   * @param msg The message you would like logged.
   * @param tr An exception to log
   */
  public static void d(String msg, Throwable tr) {
    printer.d(msg, tr);
  }

  /**
   * @param msg The message you would like logged.
   */
  public static void i(String msg) {
    printer.i(msg, null);
  }

  /**
   * @param msg The message you would like logged.
   * @param tr An exception to log
   */
  public static void i(String msg, Throwable tr) {
    printer.i(msg, tr);
  }

  /**
   * @param msg The message you would like logged.
   */
  public static void w(String msg) {
    printer.w(msg, null);
  }

  /**
   * @param msg The message you would like logged.
   * @param tr An exception to log
   */
  public static void w(String msg, Throwable tr) {
    printer.w(msg, tr);
  }


  /**
   * @param msg The message you would like logged.
   */
  public static void e(String msg) {
    printer.e(msg, null);
  }

  /**
   * @param msg The message you would like logged.
   * @param tr An exception to log
   */
  public static void e(String msg, Throwable tr) {
    printer.e(msg, tr);
  }

  public static void f(String msg) {
  }

  public static void f(String msg, Throwable tr) {
  }

  public static void setLogLevel(int logLevel) {
    LOG_LEVEL = logLevel;
  }

  /**
   * Enables DEBUG logs. Should be set to true only in development and
   * testing. Should be set to false when in going live
   */
  static boolean isLoggingEnabled = false;

  public static void enableDebugLog() {
    try {
      isLoggingEnabled = MoEngage.isDebugBuild() || isLoggingEnabled;
    } catch (Exception e) {
      Logger.e("Logger : enableDebugLog", e);
    }
  }
}
