/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.core;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.os.Build.VERSION_CODES;
import com.moengage.core.listeners.OnJobCompleteListener;
import com.moengage.core.model.MoEJobParameters;
import com.moengage.core.internal.reports.DataManager;

@TargetApi(VERSION_CODES.LOLLIPOP)
public class DataSyncJob extends JobService implements OnJobCompleteListener {

  private static final String TAG = MoEConstants.MODULE_TAG + "DataSyncJob";

  @Override public boolean onStartJob(JobParameters params) {
    try {
      Logger.v(TAG + " onStartJob() : ");
      DataManager.getInstance()
          .backgroundSync(getApplicationContext(), params.getExtras()
                  .getInt(DataManager.ATTEMPT_NUMBER, DataManager.NO_RETRY),
              new MoEJobParameters(params, this));
    } catch (Exception e) {
      Logger.e(TAG + " onStartJob() : ", e);
    }
    return true;
  }

  @Override public boolean onStopJob(JobParameters params) {
    return false;
  }

  @Override public void jobComplete(MoEJobParameters jobParameters) {
    try {
      Logger.v(TAG + " jobCompleted() : Job completed. Releasing lock.");
      jobFinished(jobParameters.jobParameters, jobParameters.isRescheduleRequired);
    } catch (Exception e) {
      Logger.e(TAG + " jobCompleted() : Exception: ", e);
    }
  }
}
