/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.moe.pushlibrary.models;

import androidx.annotation.Nullable;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.MoECoreEvaluator;
import com.moengage.core.MoEUtils;
import org.json.JSONObject;

/**
 * Represents a tracking event
 *
 * @author MoEngage (abhishek@moenegage.com)
 * @version 5.0
 * @since 5.0
 */
public class Event {

  public long _id;
  public String details;
  public long time;
  @Nullable public String eventName;
  @Nullable public JSONObject attributes;
  public boolean isInteractiveEvent = true;

  public Event(int _id, String details) {
    this(_id, -1, details, null, null);
  }

  public Event(int _id, long time, String details, String eventName, JSONObject attributes) {
    if (_id != -1) {
      this._id = _id;
    }
    if (time != -1) {
      this.time = time;
    } else {
      this.time = MoEUtils.currentMillis();
    }
    this.details = details;
    this.eventName = eventName;
    this.attributes = attributes;
    this.isInteractiveEvent = new MoECoreEvaluator().isInteractiveEvent(details);
  }

  public Event(String action, JSONObject attrs) {
    this(-1, -1, MoEHelperUtils.getDatapointJSON(action, attrs).toString(), action, attrs);
  }
}
