/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.moe.pushlibrary;

import android.location.Location;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.moe.pushlibrary.models.GeoLocation;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ISO8601Utils;
import com.moengage.core.Logger;
import com.moengage.core.MoEConstants;
import com.moengage.core.MoEUtils;
import com.moengage.core.Properties;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * A helper class for builder the tracking payload
 * <br/>Use {@link Properties} class instead of this.
 *
 * @author MoEngage (abhishek@moengage.com)
 * @version 1.0
 * @since 5.3.02
 */
@Deprecated
public class PayloadBuilder {

  private static final String TAG = MoEConstants.MODULE_TAG + "PayloadBuilder";

  private JSONObject generalAttrs;
  private JSONObject customAttrs;
  private boolean isInteractiveEvent;
  private boolean hasCalledNonInteractiveApi;

  private void notNullCheck(String attrName) throws Exception {
    if (MoEUtils.isEmptyString(attrName)) throw new Exception("Action name cannot be empty");
  }

  /**
   * Add an integer attribute value to the payload
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName The Event attribute name
   * @param attrValue The Event attribute Value
   * @return {@link PayloadBuilder} instance
   */
  @Deprecated public PayloadBuilder putAttrInt(String attrName, int attrValue) {
    try {
      notNullCheck(attrName);
      generalAttrs.put(attrName.trim(), attrValue);
    } catch (Exception e) {
      Logger.e("PayloadBuilder: putAttrInt", e);
    }
    return this;
  }

  /**
   * Add an String attribute value to the payload
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName The Event attribute name
   * @param attrValue The Event attribute Value
   * @return {@link PayloadBuilder} instance
   */
  @Deprecated public PayloadBuilder putAttrString(String attrName, String attrValue) {
    try {
      notNullCheck(attrName);
      generalAttrs.put(attrName.trim(), attrValue);
    } catch (Exception e) {
      Logger.e("PayloadBuilder: putAttrString", e);
    }
    return this;
  }

  /**
   * Add an boolean attribute value to the payload
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName The Event attribute name
   * @param attrValue The Event attribute Value
   * @return {@link PayloadBuilder} instance
   */
  @Deprecated public PayloadBuilder putAttrBoolean(String attrName, boolean attrValue) {
    try {
      notNullCheck(attrName);
      generalAttrs.put(attrName.trim(), attrValue);
    } catch (Exception e) {
      Logger.e("PayloadBuilder: putAttrBoolean", e);
    }
    return this;
  }

  /**
   * Add an float attribute value to the payload
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName The Event attribute name
   * @param attrValue The Event attribute Value
   * @return {@link PayloadBuilder} instance
   */
  @Deprecated public PayloadBuilder putAttrFloat(String attrName, float attrValue) {
    try {
      notNullCheck(attrName);
      generalAttrs.put(attrName.trim(), attrValue);
    } catch (Exception e) {
      Logger.e("PayloadBuilder: putAttrFloat", e);
    }
    return this;
  }

  /**
   * Add an double attribute value to the payload
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName The Event attribute name
   * @param attrValue The Event attribute Value
   * @return {@link PayloadBuilder} instance
   */
  @Deprecated public PayloadBuilder putAttrDouble(String attrName, double attrValue) {
    try {
      notNullCheck(attrName);
      generalAttrs.put(attrName.trim(), attrValue);
    } catch (Exception e) {
      Logger.e("PayloadBuilder: putAttrDouble", e);
    }
    return this;
  }

  /**
   * Add an long attribute value to the payload
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName The Event attribute name
   * @param attrValue The Event attribute Value
   * @return {@link PayloadBuilder} instance
   */
  @Deprecated public PayloadBuilder putAttrLong(String attrName, long attrValue) {
    try {
      notNullCheck(attrName);
      generalAttrs.put(attrName.trim(), attrValue);
    } catch (Exception e) {
      Logger.e("PayloadBuilder: putAttrLong", e);
    }
    return this;
  }

  /**
   * Add an Date attribute value to the payload
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName The Event attribute name
   * @param attrValue The Event attribute Value of type {@link Date}
   * @return {@link PayloadBuilder} instance
   */
  @Deprecated public PayloadBuilder putAttrDate(String attrName, Date attrValue) {
    try {
      notNullCheck(attrName);
      JSONArray timeStamp;
      if (customAttrs.has(ATTR_TIMESTAMP)) {
        timeStamp = customAttrs.getJSONArray(ATTR_TIMESTAMP);
      } else {
        timeStamp = new JSONArray();
      }
      JSONObject attr = new JSONObject();
      attr.put(attrName.trim(), attrValue.getTime());
      timeStamp.put(attr);
      customAttrs.put(ATTR_TIMESTAMP, timeStamp);
    } catch (Exception e) {
      Logger.e("EventPayload: putAttrDate: ", e);
    }
    return this;
  }

  /**
   * Add an Date attribute value to the payload
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName The Event attribute name
   * @param dateString String representation of Date
   * @param dateFormat Format of the date string which is being passed
   * @return {@link PayloadBuilder} instance
   */
  @Deprecated public PayloadBuilder putAttrDate(String attrName, String dateString,
      String dateFormat) {
    try {
      notNullCheck(attrName);
      DateFormat format = new SimpleDateFormat(dateFormat, Locale.ENGLISH);
      return putAttrDate(attrName.trim(), format.parse(dateString));
    } catch (Exception e) {
      Logger.e("EventPayload: putAttrDate 2: ", e);
    }
    return this;
  }

  /**
   * Add an Date attribute value to the payload
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName The Event attribute name
   * @param attrValue The Event attribute Value of type {@link GeoLocation}
   * @return {@link PayloadBuilder} instance
   */
  @Deprecated public PayloadBuilder putAttrLocation(String attrName, GeoLocation attrValue) {
    try {
      notNullCheck(attrName);
      JSONArray location;
      if (customAttrs.has(ATTR_LOCATION)) {
        location = customAttrs.getJSONArray(ATTR_LOCATION);
      } else {
        location = new JSONArray();
      }
      JSONObject attr = new JSONObject();
      attr.put(attrName.trim(), attrValue.latitude + "," + attrValue.longitude);
      location.put(attr);
      customAttrs.put(ATTR_LOCATION, location);
    } catch (Exception e) {
      Logger.e("EventPayload: putAttrLocation1: ", e);
    }
    return this;
  }

  /**
   * Add an Date attribute value to the payload
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName The Event attribute name
   * @param attrValue The Event attribute Value of type {@link Location}
   * @return {@link PayloadBuilder} instance
   */
  @Deprecated public PayloadBuilder putAttrLocation(String attrName, Location attrValue) {
    try {
      notNullCheck(attrName);
      JSONArray location;
      if (customAttrs.has(ATTR_LOCATION)) {
        location = customAttrs.getJSONArray(ATTR_LOCATION);
      } else {
        location = new JSONArray();
      }
      JSONObject attr = new JSONObject();
      attr.put(attrName.trim(), attrValue.getLatitude() + "," + attrValue.getLongitude());
      location.put(attr);
      customAttrs.put(ATTR_LOCATION, location);
    } catch (Exception e) {
      Logger.e("EventPayload: putAttrLocation2: ", e);
    }
    return this;
  }

  /**
   * Add an Date attribute value to the payload
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName The Event attribute name
   * @param latitude The latitude value of the geo location
   * @param longitude The longitude value of the geo location
   * @return {@link PayloadBuilder} instance
   */
  @Deprecated public PayloadBuilder putAttrLocation(String attrName, double latitude,
      double longitude) {
    try {
      notNullCheck(attrName);
      JSONArray location;
      if (customAttrs.has(ATTR_LOCATION)) {
        location = customAttrs.getJSONArray(ATTR_LOCATION);
      } else {
        location = new JSONArray();
      }
      JSONObject attr = new JSONObject();
      attr.put(attrName.trim(), latitude + "," + longitude);
      location.put(attr);
      customAttrs.put(ATTR_LOCATION, location);
    } catch (Exception e) {
      Logger.e("EventPayload: putAttrLocation3: ", e);
    }
    return this;
  }

  /**
   * Add an Date attribute value to the payload
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName The Event attribute name
   * @param attrValue The Event attribute Value of type long
   * @return {@link PayloadBuilder} instance
   */
  @Deprecated public PayloadBuilder putAttrDateEpoch(String attrName, long attrValue) {
    try {
      notNullCheck(attrName);
      JSONArray timeStamp;
      if (customAttrs.has(ATTR_TIMESTAMP)) {
        timeStamp = customAttrs.getJSONArray(ATTR_TIMESTAMP);
      } else {
        timeStamp = new JSONArray();
      }
      JSONObject attr = new JSONObject();
      attr.put(attrName.trim(), attrValue);
      timeStamp.put(attr);
      customAttrs.put(ATTR_TIMESTAMP, timeStamp);
    } catch (Exception e) {
      Logger.e("EventPayload: putAttrDate: ", e);
    }
    return this;
  }

  /**
   * Add a JSONArray attribute value to the payload
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName event attribute name
   * @param attrValue event attribute value
   * @return {@link PayloadBuilder} instance
   */
  @Deprecated public PayloadBuilder putAttrJSONArray(@NonNull String attrName,
      @NonNull JSONArray attrValue) {
    try {
      notNullCheck(attrName);
      if (attrValue == null) return this;
      generalAttrs.put(attrName.trim(), attrValue);
    } catch (Exception e) {
      Logger.e("EventPayload: putAttrJSONArray: ", e);
    }
    return this;
  }

  /**
   * Add a JSONObject attribute value to the payload
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName event attribute name
   * @param attrValue event attribute value
   * @return {@link PayloadBuilder} instance
   */
  @Deprecated public PayloadBuilder putAttrJSONObject(@NonNull String attrName,
      @NonNull JSONObject attrValue) {
    try {
      notNullCheck(attrName);
      if (attrValue == null) return this;
      generalAttrs.put(attrName.trim(), attrValue);
    } catch (Exception e) {
      Logger.e("EventPayload: putAttrJSONObject: ", e);
    }
    return this;
  }

  /**
   * Add a {@link Object} type attribute value to the payload.
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName event attribute name
   * @param attrValue event attribute value
   * @return {@link PayloadBuilder} instance
   *
   * <br> <b>Note:</b> Attribute value should only be wrapper class of one of the types
   * {@link Boolean}, {@link Byte}, {@link Character}, {@link Integer}, {@link Double},
   * {@link Float}, {@link Long}, {@link Short}, {@link String}.
   */
  @Deprecated public PayloadBuilder putAttrObject(@NonNull String attrName,
      @NonNull Object attrValue) {
    try {
      notNullCheck(attrName);
      if (attrValue == null) return this;
      generalAttrs.put(attrName.trim(), attrValue);
    } catch (Exception e) {
      Logger.e("EventPayload: putAttrObject() : Exception ", e);
    }
    return this;
  }

  /**
   * Add a date attribute in ISO 8601 date format.<br>
   * Accepted Format - [yyyy-MM-dd|yyyyMMdd][T(hh:mm[:ss[.sss]]|hhmm[ss[.sss]])]?[Z|[+-]hh:mm]]
   * <br/> Use {@link Properties} instead.
   *
   * @param attrName Event attribute name.
   * @param attrValue Event attribute value.
   * @return {@link PayloadBuilder} instance
   */
  @Deprecated public PayloadBuilder putAttrISO8601Date(@NonNull String attrName,
      @NonNull String attrValue) {
    try {
      notNullCheck(attrName);
      if (TextUtils.isEmpty(attrValue)) {
        Logger.w(TAG + " putAttrISO8601Date() : Attribute value cannot be empty");
        return this;
      }
      long epochValue = ISO8601Utils.parse(attrValue).getTime();
      putAttrDateEpoch(attrName, epochValue);
    } catch (Exception e) {
      Logger.e(TAG + " putAttrISO8601Date() : Not an ISO Date: " + attrValue);
    }
    return this;
  }

  /**
   * Build the Event Payload and pass it to trackEvent
   * <br/> Use {@link Properties} instead.
   *
   * @return populated EventPayload instance or null if nothing is set
   */
  @Deprecated public JSONObject build() {
    try {
      JSONObject dataPoint = new JSONObject();
      boolean nothing = true;
      if (generalAttrs.length() > 0) {
        markEventAsNonInteractiveIfRequired();
        dataPoint.put(MoEHelperUtils.EVENT_ATTRS, generalAttrs.toString());
        nothing = false;
      }
      if (customAttrs.length() > 0) {
        dataPoint.put(MoEHelperUtils.EVENT_ATTRS_CUST, customAttrs.toString());
        nothing = false;
      }
      if (nothing) {
        dataPoint.put(MoEHelperUtils.EVENT_ATTRS, new JSONObject().toString());
      }
      dataPoint.put(MoEHelperUtils.EVENT_G_TIME, Long.toString(MoEUtils.currentMillis()));
      dataPoint.put(MoEHelperUtils.EVENT_L_TIME, MoEUtils.getDateDataPointFormat());
      if (!isInteractiveEvent) {
        dataPoint.put(MoEHelperUtils.EVENT_NON_INTERACTIVE, 1);
      }
      return dataPoint;
    } catch (Exception e) {
      Logger.e(TAG + " build() Exception: ", e);
    }
    return null;
  }

  private void markEventAsNonInteractiveIfRequired() {
    try {
      if (generalAttrs.has(NON_INTERACTIVE_EVENT_ATTRIBUTE) && !hasCalledNonInteractiveApi) {
        Object attributeValue = generalAttrs.get(NON_INTERACTIVE_EVENT_ATTRIBUTE);
        if (attributeValue instanceof Integer) {
          int isNonInteractive = (Integer) attributeValue;
          isInteractiveEvent = isNonInteractive != 1;
        } else {
          Logger.v(TAG + " build() : " + NON_INTERACTIVE_EVENT_ATTRIBUTE + " is not tracked in"
              + " the expected data-type. Expected data-type in integer.");
        }
      }
      if (generalAttrs.has(NON_INTERACTIVE_EVENT_ATTRIBUTE)) {
        generalAttrs.remove(NON_INTERACTIVE_EVENT_ATTRIBUTE);
      }
    } catch (JSONException e) {
      Logger.e(TAG + " markEventAsNonInteractiveIfRequired() : Exception ", e);
    }
  }

  /**
   * Marks an event as non-interactive.
   * <br/> Use {@link Properties} instead.
   *
   * @return instance of {@link PayloadBuilder}
   */
  @Deprecated public PayloadBuilder setNonInteractive() {
    isInteractiveEvent = false;
    hasCalledNonInteractiveApi = true;
    return this;
  }

  /**
   * <br/> Use {@link Properties} instead.
   */
  @Deprecated public PayloadBuilder() {
    customAttrs = new JSONObject();
    generalAttrs = new JSONObject();
    isInteractiveEvent = true;
  }

  private static final String ATTR_TIMESTAMP = "timestamp";
  private static final String ATTR_LOCATION = "location";
  private static final String NON_INTERACTIVE_EVENT_ATTRIBUTE = "moe_non_interactive";
}
