/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.addon.trigger;

import android.os.Parcel;
import android.os.Parcelable;
import com.moengage.core.Logger;
import org.json.JSONObject;

class TriggerMessage
implements Parcelable {
    long _id;
    String campaignId;
    String triggerEventName;
    JSONObject payload;
    JSONObject campaignPayload;
    Rules rules;
    State state;
    String campaignType;
    public static final Parcelable.Creator<TriggerMessage> CREATOR = new Parcelable.Creator<TriggerMessage>(){

        public TriggerMessage createFromParcel(Parcel in) {
            return new TriggerMessage(in);
        }

        public TriggerMessage[] newArray(int size) {
            return new TriggerMessage[size];
        }
    };

    TriggerMessage() {
        this.rules = new Rules();
        this.state = new State();
        this.payload = new JSONObject();
        this.campaignPayload = new JSONObject();
    }

    protected TriggerMessage(Parcel in) {
        if (this.rules == null) {
            this.rules = new Rules();
        }
        if (this.state == null) {
            this.state = new State();
        }
        try {
            this._id = in.readLong();
            this.campaignId = in.readString();
            this.triggerEventName = in.readString();
            this.campaignType = in.readString();
            this.payload = new JSONObject(in.readString());
            this.campaignPayload = new JSONObject(in.readString());
            this.rules.maxCount = in.readLong();
            this.rules.showDelay = in.readLong();
            this.rules.minimumDelay = in.readLong();
            this.rules.shouldShowOffline = in.readInt() == 1;
            this.rules.maxSyncDelay = in.readLong();
            this.rules.expiryTime = in.readLong();
            this.rules.priority = in.readLong();
            this.rules.shouldIgnoreDND = in.readInt() == 1;
            this.state.lastShowTime = in.readLong();
            this.state.lastUpdatedTime = in.readLong();
            this.state.showCount = in.readLong();
            this.state.isActive = in.readInt() == 1;
            this.state.status = in.readString();
        }
        catch (Exception e) {
            Logger.e((String)"TriggerMessage : TriggerMessage() : ", (Throwable)e);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this._id);
        dest.writeString(this.campaignId);
        dest.writeString(this.triggerEventName);
        dest.writeString(this.campaignType);
        dest.writeString(this.payload.toString());
        dest.writeString(this.campaignPayload.toString());
        if (this.rules != null) {
            dest.writeLong(this.rules.maxCount);
            dest.writeLong(this.rules.showDelay);
            dest.writeLong(this.rules.minimumDelay);
            dest.writeInt(this.rules.shouldShowOffline ? 1 : 0);
            dest.writeLong(this.rules.maxSyncDelay);
            dest.writeLong(this.rules.expiryTime);
            dest.writeLong(this.rules.priority);
            dest.writeInt(this.rules.shouldIgnoreDND ? 1 : 0);
        }
        if (this.state != null) {
            dest.writeLong(this.state.lastShowTime);
            dest.writeLong(this.state.showCount);
            dest.writeLong(this.state.lastUpdatedTime);
            dest.writeInt(this.state.isActive ? 1 : 0);
            dest.writeString(this.state.status);
        }
    }

    public void dump() {
        try {
            StringBuilder builder = new StringBuilder("TriggerMessage: Details -> \n");
            builder.append("\n campaign-id: ").append(this.campaignId).append("\n trigger event: ").append(this.triggerEventName);
            if (this.rules != null) {
                builder.append("\n expiry time: ").append(this.rules.expiryTime).append("\n max show count: ").append(this.rules.maxCount).append("\n minimum delay: ").append(this.rules.minimumDelay).append("\n priority: ").append(this.rules.priority).append("\n shouldIgnoreDND: ").append(this.rules.shouldIgnoreDND).append("\n shouldShowOffline: ").append(this.rules.shouldShowOffline).append("\n show delay: ").append(this.rules.showDelay).append("\n max sync delay: ").append(this.rules.maxSyncDelay);
            }
            if (this.state != null) {
                builder.append("\n last show time: ").append(this.state.lastShowTime).append("\n last updated time: ").append(this.state.lastUpdatedTime).append("\n show count: ").append(this.state.showCount).append("\n status: ").append(this.state.status);
            }
            if (this.payload != null) {
                builder.append("\n push payload: ").append(this.payload.toString());
            }
            if (this.campaignPayload != null && this.campaignPayload.has("condition")) {
                builder.append("\n conditions: ").append(this.campaignPayload.getJSONObject("condition").toString());
            }
            Logger.v((String)builder.toString());
        }
        catch (Exception e) {
            Logger.e((String)"TriggerMessage dump() : ", (Throwable)e);
        }
    }

    static class State {
        long lastShowTime;
        long showCount;
        long lastUpdatedTime;
        boolean isActive;
        String status;

        State() {
        }
    }

    static class Rules {
        long maxCount;
        long showDelay;
        long minimumDelay;
        boolean shouldShowOffline;
        long maxSyncDelay;
        long expiryTime = -1L;
        long priority;
        boolean shouldIgnoreDND;

        Rules() {
        }
    }
}

