/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.addon.trigger;

import android.content.Context;
import android.os.Build;
import androidx.annotation.Nullable;
import com.moe.pushlibrary.models.Event;
import com.moengage.addon.trigger.DTController;
import com.moengage.addon.trigger.DTDAO;
import com.moengage.addon.trigger.DTParser;
import com.moengage.addon.trigger.TriggerMessage;
import com.moengage.core.APIManager;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.MoEJobParameters;
import com.moengage.core.rest.Response;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONObject;

public class DTNetworkTask
extends SDKTask {
    private static final String TAG = "RTT_3.2.04_DTNetworkTask";
    private DTController.NETWORK_CALL_TYPE mNetworkCallType;
    private Event mEvent;
    private TriggerMessage mCampaign;
    private MoEJobParameters jobParameters;

    DTNetworkTask(Context context, DTController.NETWORK_CALL_TYPE networkCallType) {
        super(context);
        this.mNetworkCallType = networkCallType;
    }

    DTNetworkTask(Context context, DTController.NETWORK_CALL_TYPE networkCallType, Event event, TriggerMessage campaign) {
        this(context, networkCallType);
        this.mEvent = event;
        this.mCampaign = campaign;
    }

    DTNetworkTask(Context context, DTController.NETWORK_CALL_TYPE networkCallType, @Nullable MoEJobParameters parameters) {
        this(context, networkCallType);
        this.jobParameters = parameters;
    }

    public TaskResult execute() {
        try {
            Logger.v((String)"RTT_3.2.04_DTNetworkTask executing");
            switch (this.mNetworkCallType) {
                case SYNC_API: {
                    LinkedList<String> campaigns = DTDAO.getInstance(this.context).getActiveCampaignIds();
                    JSONArray campaignArray = new JSONArray();
                    if (campaigns != null) {
                        for (String campaign : campaigns) {
                            campaignArray.put((Object)campaign);
                        }
                    }
                    JSONObject request = new JSONObject();
                    request.put("campaign_ids", (Object)campaignArray);
                    request.put("last_sync_time", ConfigurationProvider.getInstance((Context)this.context).getDTLastSyncTime());
                    Response response = APIManager.deviceTriggerSyncRequest((Context)this.context, (String)"v1/sdk-trigger/sync", null, (JSONObject)request);
                    DTParser.parseAndSaveSyncAPIResponse(response, this.context);
                    break;
                }
                case USER_IN_SEGMENT: {
                    JSONObject requestObject = new JSONObject(this.mEvent.details);
                    requestObject.put("campaign_id", (Object)this.mCampaign.campaignId);
                    Response response = APIManager.deviceTriggerSyncRequest((Context)this.context, (String)"v1/sdk-trigger/user-in-segment", null, (JSONObject)requestObject);
                    DTParser.parseUserInSegmentAPIResponse(response, this.mCampaign, this.context);
                }
            }
            this.releaseJobLockIfRequired();
            Logger.v((String)"RTT_3.2.04_DTNetworkTaskcompleted execution");
        }
        catch (Exception e) {
            Logger.e((String)"RTT_3.2.04_DTNetworkTaskexecute() : ", (Throwable)e);
        }
        return null;
    }

    private void releaseJobLockIfRequired() {
        if (Build.VERSION.SDK_INT >= 21 && this.jobParameters != null) {
            Logger.v((String)"RTT_3.2.04_DTNetworkTask releaseJobLockIfRequired() : Trying to release job lock.");
            this.jobParameters.jobCompleteListener.jobComplete(this.jobParameters);
        }
    }

    public String getTaskTag() {
        return "DT_NETWORK_CALL_TASK";
    }

    public boolean isSynchronous() {
        return false;
    }
}

