/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.addon.trigger;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.addon.trigger.DTConditionEvaluator;
import com.moengage.addon.trigger.DTDAO;
import com.moengage.addon.trigger.DTIntentService;
import com.moengage.addon.trigger.TriggerMessage;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.Properties;
import com.moengage.evaluator.ConditionEvaluator;
import com.moengage.pushbase.MoEPushHelper;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

class DTController {
    private static final String TAG = "RTT_3.2.04_DTController";
    private HashSet<String> mTriggerEvents;
    private Context mContext;
    private DTConditionEvaluator conditionEvaluator;
    private DTDAO dbHandler;
    private static DTController _INSTANCE;

    private DTController(@NonNull Context context) {
        this.mContext = context;
        this.dbHandler = DTDAO.getInstance(this.mContext);
        this.updateDTCache();
        this.conditionEvaluator = new DTConditionEvaluator();
    }

    public static DTController getInstance(Context context) {
        if (_INSTANCE == null) {
            _INSTANCE = new DTController(context);
        }
        return _INSTANCE;
    }

    @WorkerThread
    void updateDTCache() {
        try {
            this.mTriggerEvents = this.dbHandler.getTriggerEventsIfAny();
            if (this.mTriggerEvents != null) {
                Logger.v((String)("RTT_3.2.04_DTController updateDTCache() : device trigger event " + this.mTriggerEvents.toString()));
            } else {
                Logger.v((String)"RTT_3.2.04_DTController updateDTCache() : no device trigger events");
            }
            this.dbHandler.removeExpiredCampaigns();
        }
        catch (Exception e) {
            Logger.e((String)"RTT_3.2.04_DTController updateDTCache() : ", (Throwable)e);
        }
    }

    @Nullable
    TriggerMessage getCampaignToShown(String eventName, JSONObject eventAttributes) {
        try {
            LinkedList<TriggerMessage> campaignsForEvent = this.dbHandler.getCampaignsForEvent(eventName);
            if (campaignsForEvent == null) {
                return null;
            }
            for (TriggerMessage campaign : campaignsForEvent) {
                try {
                    Logger.v((String)("RTT_3.2.04_DTController getCampaignToShown() : evaluating conditions for campaign id: " + campaign.campaignId));
                    campaign.dump();
                    if (!this.conditionEvaluator.canShowTriggerMessage(campaign, this.getLastSyncTime(), System.currentTimeMillis()) || campaign.campaignPayload == null) continue;
                    if (!campaign.campaignPayload.has("condition")) {
                        return campaign;
                    }
                    JSONObject conditions = campaign.campaignPayload.getJSONObject("condition");
                    ConditionEvaluator evaluator = new ConditionEvaluator(conditions, MoEHelperUtils.transformEventAttributesForEvaluationPackage((JSONObject)eventAttributes));
                    boolean evaluationResult = evaluator.evaluate();
                    Logger.v((String)("RTT_3.2.04_DTController getCampaignToShown() : Evaluation result: " + evaluationResult));
                    if (!evaluationResult) continue;
                    return campaign;
                }
                catch (Exception e) {
                    Logger.e((String)"RTT_3.2.04_DTControllergetCampaignToShown() : inside for loop ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            Logger.e((String)"RTT_3.2.04_DTControllergetCampaignToShown() : ", (Throwable)e);
        }
        return null;
    }

    void showOrScheduleNotificationOnline(TriggerMessage message) {
        if (this.conditionEvaluator.isPayloadEmpty(message)) {
            return;
        }
        if (message.rules.showDelay == 0L) {
            this.showPushAndUpdateCounter(message);
        } else {
            this.schedulePushNotification(message, false);
        }
    }

    void showOrScheduleNotificationOffline(TriggerMessage message) throws JSONException {
        if (!message.rules.shouldShowOffline || this.conditionEvaluator.isPayloadEmpty(message)) {
            return;
        }
        message.payload.put("shownOffline", true);
        if (message.rules.showDelay == 0L) {
            this.tryShowingNotificationOffline(message);
        } else {
            this.schedulePushNotification(message, true);
        }
    }

    private void updateCampaignState(TriggerMessage message) {
        ++message.state.showCount;
        message.state.lastShowTime = System.currentTimeMillis();
        ConfigurationProvider.getInstance((Context)this.mContext).saveLastDTShowTime(message.state.lastShowTime);
        this.dbHandler.updateCampaignState(message);
    }

    void tryShowingNotificationOffline(TriggerMessage message) {
        try {
            Calendar rightNow = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            int currentHour = rightNow.get(11);
            int currentMinutes = rightNow.get(12);
            if (this.conditionEvaluator.isDNDActive(this.getDNDStartTime(), this.getDNDEndTime(), currentHour, currentMinutes) && !message.rules.shouldIgnoreDND) {
                Logger.v((String)"RTT_3.2.04_DTController tryShowingNotificationOffline() : dnd is active cannot show notification");
                return;
            }
            String campaignId = message.payload.getString("gcm_campaign_id");
            Properties properties = new Properties();
            properties.addAttribute("gcm_campaign_id", (Object)campaignId).setNonInteractive();
            MoEHelper.getInstance((Context)this.mContext).trackEvent(MoEHelperConstants.NOTIFICATION_OFFLINE_MOE, properties);
            message.payload.put("gcm_campaign_id", (Object)(campaignId + "DTSDK" + System.currentTimeMillis()));
            this.showPushAndUpdateCounter(message);
        }
        catch (Exception e) {
            Logger.e((String)"RTT_3.2.04_DTController tryShowingNotificationOffline() : ", (Throwable)e);
        }
    }

    void showScheduledNotification(String campaignId, boolean isOffline, String payload) {
        try {
            TriggerMessage message = this.dbHandler.getCampaignById(campaignId);
            if (message != null) {
                message.payload = new JSONObject(payload);
                if (isOffline) {
                    this.tryShowingNotificationOffline(message);
                } else {
                    this.showPushAndUpdateCounter(message);
                }
            } else {
                Logger.e((String)("RTT_3.2.04_DTController showScheduledNotification() : did not find campaign with id: " + campaignId));
            }
        }
        catch (Exception e) {
            Logger.e((String)"RTT_3.2.04_DTController showScheduledNotification() : ", (Throwable)e);
        }
    }

    void showPushAndUpdateCounter(TriggerMessage message) {
        try {
            if (message.rules.expiryTime < System.currentTimeMillis() || this.conditionEvaluator.isPayloadEmpty(message)) {
                Logger.e((String)("RTT_3.2.04_DTController showPushAndUpdateCounter() : cannot show trigger message for campaign id: " + message.campaignId));
                return;
            }
            Bundle pushPayload = MoEUtils.jsonToBundle((JSONObject)message.payload);
            if (pushPayload == null) {
                Logger.e((String)("RTT_3.2.04_DTController showPushAndUpdateCounter() : could not convert json to bundle, cannot show campaign for campaign id: " + message.campaignId));
                return;
            }
            MoEPushHelper.getInstance().handlePushPayload(this.mContext, pushPayload);
            this.updateCampaignState(message);
        }
        catch (Exception e) {
            Logger.e((String)"RTT_3.2.04_DTController showPushAndUpdateCounter() : ", (Throwable)e);
        }
    }

    void schedulePushNotification(TriggerMessage message, boolean isOffline) {
        try {
            Logger.v((String)("RTT_3.2.04_DTController schedulePushNotification() : will schedule notification for campaign id: " + message.campaignId));
            Intent laterIntent = new Intent(this.mContext, DTIntentService.class);
            laterIntent.putExtra("isOffline", isOffline);
            laterIntent.putExtra("NOTIFICATION_EXTRA", message.campaignId);
            laterIntent.putExtra("NOTIFICATION_PAYLOAD", message.payload.toString());
            laterIntent.setAction("ACTION_SHOW_NOTIFICATION");
            int _id = (int)System.currentTimeMillis();
            PendingIntent alarmPendingIntent = PendingIntent.getService((Context)this.mContext, (int)_id, (Intent)laterIntent, (int)0x8000000);
            AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
            if (alarmManager != null) {
                alarmManager.set(0, System.currentTimeMillis() + message.rules.showDelay, alarmPendingIntent);
            }
            Properties builder = new Properties();
            builder.addAttribute("campaign_id", (Object)message.campaignId);
            builder.setNonInteractive();
            MoEHelper.getInstance((Context)this.mContext).trackEvent(MoEHelperConstants.DT_CAMPAIGN_SCHEDULED, builder);
        }
        catch (Exception e) {
            Logger.e((String)"RTT_3.2.04_DTController schedulePushNotification() : ", (Throwable)e);
        }
    }

    @Nullable
    HashSet<String> getTriggerEvents() {
        return this.mTriggerEvents;
    }

    long getGlobalMinimumDelay() {
        return ConfigurationProvider.getInstance((Context)this.mContext).getDTMinimumDelay();
    }

    long getLastShowTime() {
        return ConfigurationProvider.getInstance((Context)this.mContext).getDTLastShowTime();
    }

    long getDNDStartTime() {
        return ConfigurationProvider.getInstance((Context)this.mContext).getDTDNDStartTime();
    }

    long getDNDEndTime() {
        return ConfigurationProvider.getInstance((Context)this.mContext).getDNDEndTime();
    }

    long getLastSyncTime() {
        return ConfigurationProvider.getInstance((Context)this.mContext).getDTLastSyncTime();
    }

    public static enum NETWORK_CALL_TYPE {
        SYNC_API,
        USER_IN_SEGMENT;

    }
}

