/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.addon.trigger;

import androidx.annotation.Nullable;
import com.moengage.addon.trigger.TriggerMessage;
import com.moengage.core.Logger;
import com.moengage.core.MoECoreEvaluator;
import java.util.HashSet;

public class DTConditionEvaluator {
    private static final String TAG = "RTT_3.2.04_DTConditionEvaluator";

    boolean isDTEvent(@Nullable HashSet<String> triggerEvents, String eventName) {
        return triggerEvents != null && triggerEvents.contains(eventName);
    }

    boolean shouldShowTrigger(long lastShowTime, long globalMinimumDelay, long currentTime) {
        return lastShowTime + globalMinimumDelay < currentTime;
    }

    boolean isDNDActive(long startTime, long endTime, int currentHour, int currentMinutes) {
        return new MoECoreEvaluator().canShowCampaignNow(startTime, endTime, currentHour, currentMinutes);
    }

    boolean canShowTriggerMessage(TriggerMessage triggerMessage, long lastSyncTime, long currentTime) {
        if (!triggerMessage.campaignType.equals("general")) {
            Logger.i((String)("RTT_3.2.04_DTConditionEvaluator canShowTriggerMessage() : " + triggerMessage.campaignId + " is not of type general. Cannot show"));
            return false;
        }
        if (!triggerMessage.state.isActive || triggerMessage.rules.expiryTime < currentTime) {
            Logger.i((String)("RTT_3.2.04_DTConditionEvaluator canShowTriggerMessage() : " + triggerMessage.campaignId + " is no longer active cannot show"));
            return false;
        }
        if (triggerMessage.rules.maxSyncDelay + lastSyncTime < currentTime && lastSyncTime != 0L) {
            Logger.i((String)("RTT_3.2.04_DTConditionEvaluator canShowTriggerMessage() : " + triggerMessage.campaignId + " has not been updated in a while. Cannot show without update"));
            return false;
        }
        if (triggerMessage.rules.minimumDelay + triggerMessage.state.lastShowTime > currentTime) {
            Logger.i((String)("RTT_3.2.04_DTConditionEvaluator canShowTriggerMessage() : " + triggerMessage.campaignId + " was shown recently. Cannot show now"));
            return false;
        }
        if (triggerMessage.rules.maxCount != -9090909L && triggerMessage.rules.maxCount <= triggerMessage.state.showCount) {
            Logger.i((String)("RTT_3.2.04_DTConditionEvaluatorcanShowTriggerMessage() : " + triggerMessage.campaignId + " has been shown maximum number of times. Cannot be shown again"));
            return false;
        }
        return true;
    }

    boolean isPayloadEmpty(TriggerMessage message) {
        return message.payload == null || message.payload.length() == 0;
    }
}

