/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.addon.trigger;

import android.content.Context;
import com.moe.pushlibrary.models.Event;
import com.moengage.addon.trigger.DTConditionEvaluator;
import com.moengage.addon.trigger.DTController;
import com.moengage.addon.trigger.DTNetworkTask;
import com.moengage.addon.trigger.TriggerMessage;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;

public class CheckAndShowDTCampaignTask
extends SDKTask {
    private static final String TAG = "RTT_3.2.04_CheckAndShowDTCampaignTask";
    private String eventName;
    private JSONObject eventAttributes;

    public CheckAndShowDTCampaignTask(Context context, String eventName, JSONObject eventAttributes) {
        super(context);
        this.eventName = eventName;
        this.eventAttributes = eventAttributes;
    }

    public TaskResult execute() {
        Logger.v((String)"RTT_3.2.04_CheckAndShowDTCampaignTaskexecuting :");
        try {
            DTConditionEvaluator conditionEvaluator = new DTConditionEvaluator();
            DTController dtController = DTController.getInstance(this.context);
            if (!conditionEvaluator.shouldShowTrigger(dtController.getLastShowTime(), dtController.getGlobalMinimumDelay(), System.currentTimeMillis())) {
                Logger.v((String)"RTT_3.2.04_CheckAndShowDTCampaignTaskexecute() : device trigger was shown recently cannot show now.");
                return null;
            }
            if (conditionEvaluator.isDTEvent(dtController.getTriggerEvents(), this.eventName)) {
                Logger.v((String)("RTT_3.2.04_CheckAndShowDTCampaignTaskexecute() : " + this.eventName + " is a device trigger"));
                TriggerMessage campaign = DTController.getInstance(this.context).getCampaignToShown(this.eventName, this.eventAttributes);
                if (campaign != null) {
                    Logger.v((String)("RTT_3.2.04_CheckAndShowDTCampaignTaskexecute() : Will try to show campaign, id: " + campaign.campaignId));
                    campaign.dump();
                    MoEDispatcher.getInstance((Context)this.context).addTaskToQueueBeginning((ITask)new DTNetworkTask(this.context, DTController.NETWORK_CALL_TYPE.USER_IN_SEGMENT, new Event(this.eventName.trim(), this.eventAttributes), campaign));
                } else {
                    Logger.v((String)"RTT_3.2.04_CheckAndShowDTCampaignTaskexecute() : Did not find any suitable device trigger campaign to show");
                }
            } else {
                Logger.v((String)("RTT_3.2.04_CheckAndShowDTCampaignTask execute() : Tracked event is not a device trigger, event: " + this.eventName));
            }
        }
        catch (Exception e) {
            Logger.e((String)"RTT_3.2.04_CheckAndShowDTCampaignTaskexecute() : ", (Throwable)e);
        }
        Logger.v((String)"RTT_3.2.04_CheckAndShowDTCampaignTaskcompleted execution : ");
        return null;
    }

    public String getTaskTag() {
        return "CHECK_AND_SHOW_DT";
    }

    public boolean isSynchronous() {
        return false;
    }
}

