/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.addon.trigger;

import android.app.IntentService;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.moengage.core.Logger;

/**
 * An {@link IntentService} subclass for handling asynchronous task requests in
 * a service on a separate handler thread.
 */
public class DTIntentService extends IntentService {

  private static final String TAG = DTConstants.MODULE_TAG + "DTIntentService";
  public DTIntentService() {
    super("DTIntentService");
  }

  @Override protected void onHandleIntent(Intent intent) {
    Logger.v(TAG + "onHandleIntent() : ");
    try {
      if (intent == null) return;
      String action  = intent.getAction();
      if (TextUtils.isEmpty(action)) return;
      Logger.v(TAG + "onHandleIntent() : Action " + action);
      switch (action){
        case DTConstants.ACTION_SYNC_MESSAGES:
          DTHandlerImpl.getInstance().syncTriggersIfRequired(getApplicationContext());
          break;
        case DTConstants.ACTION_SHOW_NOTIFICATION:
          Bundle bundle = intent.getExtras();
          if (bundle != null){
            String campaignId = bundle.getString(DTConstants.EXTRA_SHOW_NOTIFICATION);
            boolean isOffline = bundle.getBoolean(DTConstants.EXTRA_ATTR_OFFLINE);
            String payload = bundle.getString(DTConstants.EXTRA_NOTIFICATION_PAYLOAD);
            DTController.getInstance(getApplicationContext()).showScheduledNotification
                (campaignId, isOffline, payload);
          }
          break;
      }
    } catch (Exception e) {
      Logger.e(TAG + "onHandleIntent() : ", e);
    }
  }
}
