/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.addon.trigger;

/**
 * @author Umang Chamaria
 */

interface DTConstants {

  String RESPONSE_ATTR_MINIMUM_DELAY_ACROSS_CAMPAIGNS = "min_delay_across_campaigns";

  String RESPONSE_ATTR_DND_START_TIME = "dnd_start_time";

  String RESPONSE_ATTR_DND_END_TIME = "dnd_end_time";

  String RESPONSE_ATTR_CAMPAIGN_LIST = "campaigns";

  String RESPONSE_ATTR_CAMPAIGN_ID = "campaign_id";

  String RESPONSE_ATTR_EVENT_NAME = "trigger_event_name";

  String RESPONSE_ATTR_FILTER = "filters";

  String RESPONSE_ATTR_FILTER_OPERATOR = "filter_operator";


  String RESPONSE_ATTR_CONDITION = "condition";

  String RESPONSE_ATTR_PAYLOAD = "payload";

  String RESPONSE_ATTR_EXPIRY = "expiry";

  String RESPONSE_ATTR_MAX_TIMES = "max_times";

  String RESPONSE_ATTR_SHOW_CAMPAIGN_AFTER = "show_delay";

  String RESPONSE_ATTR_MINIMUM_DELAY_BETWEEN = "min_delay_between_notifications";

  String RESPONSE_ATTR_MAXIMUM_SYNC_DELAY = "max_sync_delay";

  String RESPONSE_ATTR_SHOULD_SUPPORT_OFFLINE = "should_support_offline";

  String RESPONSE_ATTR_SHOULD_IGNORE_DND = "should_ignore_dnd";

  String RESPONSE_ATTR_CAMPAIGN_TYPE = "type";

  String RESPONSE_ATTR_PRIORITY = "priority";

  String RESPONSE_ATTR_STATUS = "status";

  String RESPONSE_ATTR_LAST_UPDATED_TIME = "last_updated";

  String RESPONSE_ATTR_USER_IN_SEGMENT = "user_in_segment";

  String RESPONSE_ATTR_SHOW_NOTIFICATION = "show_notification";

  String RESPONSE_ATTR_USER_NOT_FOUND = "user_not_found";

  String CAMPAIGN_STATUS_ACTIVE = "active";

  String CAMPAIGN_STATUS_PAUSE = "pause";

  String CAMPAIGN_STATUS_STOPPED = "stopped";

  String CAMPAIGN_STATUS_EXPIRED = "expired";

  String ENDPOINT_SYNC_DT = "v1/sdk-trigger/sync";

  String ENDPOINT_USER_IN_SEGMENT = "v1/sdk-trigger/user-in-segment";

  String REQUEST_ATTR_LAST_SYNC_TIME = "last_sync_time";

  String REQUEST_ATTR_CAMPAIGN_IDS = "campaign_ids";

  String ACTION_SYNC_MESSAGES = "ACTION_SYNC_MESSAGES";

  String ACTION_SHOW_NOTIFICATION = "ACTION_SHOW_NOTIFICATION";

  String EXTRA_SHOW_NOTIFICATION = "NOTIFICATION_EXTRA";

  String EXTRA_NOTIFICATION_PAYLOAD = "NOTIFICATION_PAYLOAD";

  int REQ_CODE_FETCH_TRIGGERS = 10002;

  int DT_SYNC_JOB_ID = 99912;

  String CAMPAIGN_TYPE_GENERAL = "general";

  String FILTER_OPERATOR_AND = "and";

  String FILTER_OPERATOR_OR = "or";

  String EXTRA_ATTR_OFFLINE = "isOffline";

  String MODULE_TAG = "RTT_" + BuildConfig.MOENGAGE_RTT_VERSION + "_";
}
