/*
 * Copyright (c) 2014-2020 MoEngage Inc.
 *
 * All rights reserved.
 *
 *  Use of source code or binaries contained within MoEngage SDK is permitted only to enable use of the MoEngage platform by customers of MoEngage.
 *  Modification of source code and inclusion in mobile apps is explicitly allowed provided that all other conditions are met.
 *  Neither the name of MoEngage nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *  Redistribution of source code or binaries is disallowed except with specific prior written permission. Any such redistribution must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.moengage.addon.trigger;

import android.content.Context;
import com.moe.pushlibrary.models.Event;
import com.moengage.addon.trigger.DTController.NETWORK_CALL_TYPE;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */

public class CheckAndShowDTCampaignTask extends SDKTask {

  private static final String TAG = DTConstants.MODULE_TAG + "CheckAndShowDTCampaignTask";

  private String eventName;
  private JSONObject eventAttributes;

  public CheckAndShowDTCampaignTask(Context context, String eventName, JSONObject eventAttributes) {
    super(context);
    this.eventName = eventName;
    this.eventAttributes = eventAttributes;
  }

  @Override public TaskResult execute() {
    Logger.v(TAG + "executing :");
    try {
      DTConditionEvaluator conditionEvaluator = new DTConditionEvaluator();
      DTController dtController = DTController.getInstance(context);
      if (!conditionEvaluator.shouldShowTrigger(dtController.getLastShowTime(),
          dtController.getGlobalMinimumDelay(), System.currentTimeMillis())) {
        Logger.v(TAG + "execute() : device trigger was shown recently cannot show now.");
        return null;
      }
      if (conditionEvaluator.isDTEvent(dtController.getTriggerEvents(), eventName)){
        Logger.v(TAG + "execute() : " + eventName + " is a device trigger");
        TriggerMessage campaign = DTController.getInstance(context).getCampaignToShown(eventName,
            eventAttributes);
        if (campaign != null){
          Logger.v(TAG + "execute() : Will try to show campaign, id: " + campaign.campaignId);
          campaign.dump();
          MoEDispatcher.getInstance(context).addTaskToQueueBeginning(new DTNetworkTask(context,
           NETWORK_CALL_TYPE.USER_IN_SEGMENT, new Event(eventName.trim(), eventAttributes), campaign));
        }else {
          Logger.v( TAG + "execute() : Did not find any suitable device trigger campaign to show");
        }
      }else {
        Logger.v(TAG + " execute() : Tracked event is not a device trigger, event: " + eventName);
      }
    }catch (Exception e){
      Logger.e(TAG + "execute() : ", e);
    }
    Logger.v(TAG + "completed execution : ");
    return null;

  }

  @Override public String getTaskTag() {
    return TAG_CHECK_AND_SHOW_DT;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
