/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.addon.trigger;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.moengage.addon.trigger.DTController;
import com.moengage.addon.trigger.DTDAO;
import com.moengage.addon.trigger.TriggerMessage;
import com.moengage.core.APIResponse;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONObject;

public class DTParser {
    private static final String TAG = "DTParser";

    static void parseAndSaveSyncAPIResponse(APIResponse response, Context context) {
        Logger.v((String)"DTParserparseAndSaveSyncAPIResponse() : will try to parse API response app");
        if (DTParser.parseAndSaveCampaign(context, response)) {
            DTController.getInstance(context).updateDTCache();
        }
    }

    static void parseUserInSegmentAPIResponse(APIResponse response, TriggerMessage message, Context context) {
        try {
            if (response == null) {
                DTController.getInstance(context).showOrScheduleNotificationOffline(message);
                return;
            }
            if (response.responseCode == 200) {
                if (TextUtils.isEmpty((CharSequence)response.responseBody)) {
                    return;
                }
                JSONObject responseObject = new JSONObject(response.responseBody);
                if (!responseObject.getBoolean("user_in_segment") || !responseObject.getBoolean("show_notification")) {
                    return;
                }
                message.payload = responseObject.getJSONObject("payload");
                DTController.getInstance(context).showOrScheduleNotificationOnline(message);
            } else {
                DTController.getInstance(context).showOrScheduleNotificationOffline(message);
            }
        }
        catch (Exception e) {
            Logger.f((String)"DTParserparseUserInSegmentAPIResponse() : ", (Throwable)e);
        }
    }

    @WorkerThread
    static boolean parseAndSaveCampaign(@NonNull Context context, APIResponse response) {
        try {
            if (response == null) {
                return false;
            }
            if (response.responseCode != 200) {
                return false;
            }
            if (TextUtils.isEmpty((CharSequence)response.responseBody)) {
                return false;
            }
            JSONObject responseJSON = new JSONObject(response.responseBody);
            if (responseJSON.has("user_not_found")) {
                if (!responseJSON.getBoolean("user_not_found")) {
                    ConfigurationProvider.getInstance((Context)context).saveLastDTSyncTime(System.currentTimeMillis());
                }
            } else {
                ConfigurationProvider.getInstance((Context)context).saveLastDTSyncTime(System.currentTimeMillis());
            }
            if (responseJSON.has("min_delay_across_campaigns")) {
                ConfigurationProvider.getInstance((Context)context).saveDTMinimumDelay(responseJSON.getLong("min_delay_across_campaigns"));
            }
            if (responseJSON.has("dnd_start_time")) {
                ConfigurationProvider.getInstance((Context)context).saveDTDNDStartTime(responseJSON.getLong("dnd_start_time"));
            }
            if (responseJSON.has("dnd_end_time")) {
                ConfigurationProvider.getInstance((Context)context).saveDNDEndTime(responseJSON.getLong("dnd_end_time"));
            }
            if (responseJSON.has("campaigns")) {
                JSONArray campaignList = responseJSON.getJSONArray("campaigns");
                LinkedList<TriggerMessage> triggerCampaignList = new LinkedList<TriggerMessage>();
                for (int i = 0; i < campaignList.length(); ++i) {
                    TriggerMessage message = DTParser.parseDTCampaign(campaignList.getJSONObject(i));
                    if (message == null) continue;
                    message.dump();
                    triggerCampaignList.add(message);
                }
                DTDAO.getInstance(context).addOrUpdateTriggerCampaigns(triggerCampaignList);
            }
            return true;
        }
        catch (Exception e) {
            Logger.f((String)"DTParserparseAndSaveCampaign() : ", (Throwable)e);
            return false;
        }
    }

    @Nullable
    static TriggerMessage parseDTCampaign(JSONObject campaignObject) {
        try {
            TriggerMessage triggerMessage = new TriggerMessage();
            triggerMessage.campaignId = campaignObject.getString("campaign_id");
            triggerMessage.state.status = campaignObject.getString("status");
            triggerMessage.campaignPayload = campaignObject;
            if (campaignObject.has("type")) {
                triggerMessage.campaignType = campaignObject.getString("type");
            }
            if (campaignObject.has("payload")) {
                triggerMessage.payload = campaignObject.getJSONObject("payload");
            }
            if (campaignObject.has("trigger_event_name")) {
                triggerMessage.triggerEventName = campaignObject.getString("trigger_event_name");
            }
            if (campaignObject.has("max_times")) {
                triggerMessage.rules.maxCount = campaignObject.getLong("max_times");
            }
            if (campaignObject.has("show_delay")) {
                triggerMessage.rules.showDelay = campaignObject.getLong("show_delay");
            }
            if (campaignObject.has("min_delay_between_notifications")) {
                triggerMessage.rules.minimumDelay = campaignObject.getLong("min_delay_between_notifications");
            }
            if (campaignObject.has("should_support_offline")) {
                triggerMessage.rules.shouldShowOffline = campaignObject.getBoolean("should_support_offline");
            }
            if (campaignObject.has("max_sync_delay")) {
                triggerMessage.rules.maxSyncDelay = campaignObject.getLong("max_sync_delay");
            }
            if (campaignObject.has("expiry")) {
                triggerMessage.rules.expiryTime = campaignObject.getLong("expiry");
            }
            if (campaignObject.has("priority")) {
                triggerMessage.rules.priority = campaignObject.getInt("priority");
            }
            if (campaignObject.has("should_ignore_dnd")) {
                triggerMessage.rules.shouldIgnoreDND = campaignObject.getBoolean("should_ignore_dnd");
            }
            if (campaignObject.has("last_updated")) {
                triggerMessage.state.lastUpdatedTime = campaignObject.getLong("last_updated");
            }
            return triggerMessage;
        }
        catch (Exception e) {
            Logger.f((String)"DTParserparseDTCampaign() :", (Throwable)e);
            return null;
        }
    }
}

