/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.addon.trigger;

import android.app.job.JobParameters;
import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import com.moe.pushlibrary.models.Event;
import com.moengage.addon.trigger.DTController;
import com.moengage.addon.trigger.DTDAO;
import com.moengage.addon.trigger.DTParser;
import com.moengage.addon.trigger.TriggerMessage;
import com.moengage.core.APIManager;
import com.moengage.core.APIResponse;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.OnJobComplete;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONObject;

public class DTNetworkTask
extends SDKTask {
    private static final String TAG = "DTNetworkTask";
    private DTController.NETWORK_CALL_TYPE mNetworkCallType;
    private Event mEvent;
    private TriggerMessage mCampaign;
    private OnJobComplete jobcompleteCallback;
    private JobParameters jobParameters;

    DTNetworkTask(Context context, DTController.NETWORK_CALL_TYPE networkCallType) {
        super(context);
        this.mNetworkCallType = networkCallType;
    }

    DTNetworkTask(Context context, DTController.NETWORK_CALL_TYPE networkCallType, Event event, TriggerMessage campaign) {
        this(context, networkCallType);
        this.mEvent = event;
        this.mCampaign = campaign;
    }

    DTNetworkTask(Context context, DTController.NETWORK_CALL_TYPE networkCallType, @Nullable OnJobComplete onJobComplete, @Nullable JobParameters parameters) {
        this(context, networkCallType);
        this.jobcompleteCallback = onJobComplete;
        this.jobParameters = parameters;
    }

    public TaskResult execute() {
        try {
            Logger.v((String)"DTNetworkTask executing");
            switch (this.mNetworkCallType) {
                case SYNC_API: {
                    LinkedList<String> campaigns = DTDAO.getInstance(this.mContext).getActiveCampaignIds();
                    JSONArray campaignArray = new JSONArray();
                    if (campaigns != null) {
                        for (String campaign : campaigns) {
                            campaignArray.put((Object)campaign);
                        }
                    }
                    JSONObject request = new JSONObject();
                    request.put("campaign_ids", (Object)campaignArray);
                    request.put("last_sync_time", ConfigurationProvider.getInstance((Context)this.mContext).getDTLastSyncTime());
                    APIResponse response = APIManager.deviceTriggerSyncRequest((Context)this.mContext, (String)(MoEUtils.getAPIRoute((Context)this.mContext) + "/v1/sdk-trigger/sync"), null, (JSONObject)request);
                    DTParser.parseAndSaveSyncAPIResponse(response, this.mContext);
                    break;
                }
                case USER_IN_SEGMENT: {
                    JSONObject requestObject = new JSONObject(this.mEvent.details);
                    requestObject.put("campaign_id", (Object)this.mCampaign.campaignId);
                    APIResponse response = APIManager.deviceTriggerSyncRequest((Context)this.mContext, (String)(MoEUtils.getAPIRoute((Context)this.mContext) + "/v1/sdk-trigger/user-in-segment"), null, (JSONObject)requestObject);
                    DTParser.parseUserInSegmentAPIResponse(response, this.mCampaign, this.mContext);
                }
            }
            this.releaseJobLockIfRequired();
            Logger.v((String)"DTNetworkTaskcompleted execution");
        }
        catch (Exception e) {
            Logger.f((String)"DTNetworkTaskexecute() : ", (Throwable)e);
        }
        return null;
    }

    private void releaseJobLockIfRequired() {
        if (Build.VERSION.SDK_INT >= 21 && this.jobcompleteCallback != null && this.jobParameters != null) {
            Logger.v((String)"DTNetworkTask releaseJobLockIfRequired() : Trying to release job lock.");
            this.jobcompleteCallback.jobCompleted(this.jobParameters, false);
        }
    }

    public String getTaskTag() {
        return "DT_NETWORK_CALL_TASK";
    }

    public boolean isSynchronous() {
        return false;
    }
}

