/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.addon.trigger;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.moe.pushlibrary.PayloadBuilder;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.addon.trigger.DTConditionEvaluator;
import com.moengage.addon.trigger.DTDAO;
import com.moengage.addon.trigger.DTIntentService;
import com.moengage.addon.trigger.TriggerMessage;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEEventManager;
import com.moengage.core.MoEUtils;
import com.moengage.core.segmentation.FilterEvaluator;
import com.moengage.push.PushManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DTController {
    private static final String TAG = "DTController";
    private HashSet<String> mTriggerEvents;
    private Context mContext;
    private DTConditionEvaluator mConditionEvaluator;
    private DTDAO dbHandler;
    private static DTController _INSTANCE;

    private DTController(@NonNull Context context) {
        this.mContext = context;
        this.dbHandler = DTDAO.getInstance(this.mContext);
        this.updateDTCache();
        this.mConditionEvaluator = new DTConditionEvaluator();
    }

    public static DTController getInstance(Context context) {
        if (_INSTANCE == null) {
            _INSTANCE = new DTController(context);
        }
        return _INSTANCE;
    }

    @WorkerThread
    void updateDTCache() {
        try {
            this.mTriggerEvents = this.dbHandler.getTriggerEventsIfAny();
            if (this.mTriggerEvents != null) {
                Logger.v((String)("DTController updateDTCache() : device trigger event " + this.mTriggerEvents.toString()));
            } else {
                Logger.v((String)"DTController updateDTCache() : no device trigger events");
            }
            this.dbHandler.removeExpiredCampaigns();
        }
        catch (Exception e) {
            Logger.f((String)"DTController updateDTCache() : ", (Throwable)e);
        }
    }

    @Nullable
    TriggerMessage getCampaignToShown(String eventName, JSONObject eventAttributes) {
        try {
            LinkedList<TriggerMessage> campaignsForEvent = this.dbHandler.getCampaignsForEvent(eventName);
            if (campaignsForEvent == null) {
                return null;
            }
            for (TriggerMessage campaign : campaignsForEvent) {
                try {
                    Logger.v((String)("DTController getCampaignToShown() : evaluating conditions for campaign id: " + campaign.campaignId));
                    campaign.dump();
                    if (!this.mConditionEvaluator.canShowTriggerMessage(campaign, this.getLastSyncTime(), System.currentTimeMillis()) || campaign.campaignPayload == null) continue;
                    if (!campaign.campaignPayload.has("condition")) {
                        return campaign;
                    }
                    JSONObject conditions = campaign.campaignPayload.getJSONObject("condition");
                    JSONArray filters = conditions.getJSONArray("filters");
                    String filterOperator = campaign.campaignPayload.optString("filter_operator", "and");
                    if (filters == null) continue;
                    if (filters.length() == 0) {
                        Logger.v((String)("DTController getCampaignToShown() : campaign does not have filters only trigger event will try to show campaign with id: " + campaign.campaignId));
                        return campaign;
                    }
                    ArrayList<Boolean> isSatisfied = new ArrayList<Boolean>(filters.length());
                    for (int i = 0; i < filters.length(); ++i) {
                        JSONObject filter = filters.getJSONObject(i);
                        boolean filterEvaluationResult = new FilterEvaluator(filter, eventAttributes).evaluate();
                        Logger.v((String)("DTController getCampaignToShown() : filter evaluation result for filter : " + filter.toString() + "is: " + filterEvaluationResult));
                        isSatisfied.add(filterEvaluationResult);
                    }
                    switch (filterOperator) {
                        case "and": {
                            if (isSatisfied.contains(Boolean.FALSE)) break;
                            return campaign;
                        }
                        case "or": {
                            if (!isSatisfied.contains(Boolean.TRUE)) break;
                            return campaign;
                        }
                    }
                }
                catch (Exception e) {
                    Logger.f((String)"DTControllergetCampaignToShown() : inside for loop ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            Logger.f((String)"DTControllergetCampaignToShown() : ", (Throwable)e);
        }
        return null;
    }

    void showOrScheduleNotificationOnline(TriggerMessage message) {
        if (this.mConditionEvaluator.isPayloadEmpty(message)) {
            return;
        }
        if (message.rules.showDelay == 0L) {
            this.showPushAndUpdateCounter(message);
        } else {
            this.schedulePushNotification(message, false);
        }
    }

    void showOrScheduleNotificationOffline(TriggerMessage message) throws JSONException {
        if (!message.rules.shouldShowOffline || this.mConditionEvaluator.isPayloadEmpty(message)) {
            return;
        }
        message.payload.put("shownOffline", true);
        if (message.rules.showDelay == 0L) {
            this.tryShowingNotificationOffline(message);
        } else {
            this.schedulePushNotification(message, true);
        }
    }

    private void updateCampaignState(TriggerMessage message) {
        ++message.state.showCount;
        message.state.lastShowTime = System.currentTimeMillis();
        ConfigurationProvider.getInstance((Context)this.mContext).saveLastDTShowTime(message.state.lastShowTime);
        this.dbHandler.updateCampaignState(message);
    }

    void tryShowingNotificationOffline(TriggerMessage message) {
        try {
            Calendar rightNow = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            int currentHour = rightNow.get(11);
            int currentMinutes = rightNow.get(12);
            if (this.mConditionEvaluator.isDNDActive(this.getDNDStartTime(), this.getDNDEndTime(), currentHour, currentMinutes) && !message.rules.shouldIgnoreDND) {
                Logger.e((String)"DTController tryShowingNotificationOffline() : dnd is active cannot show notification");
                return;
            }
            String campaignId = message.payload.getString("gcm_campaign_id");
            PayloadBuilder builder = new PayloadBuilder();
            builder.putAttrString("gcm_campaign_id", campaignId);
            MoEEventManager.getInstance((Context)this.mContext).trackEvent(MoEHelperConstants.NOTIFICATION_OFFLINE_MOE, builder.build());
            message.payload.put("gcm_campaign_id", (Object)(campaignId + "DTSDK" + System.currentTimeMillis()));
            this.showPushAndUpdateCounter(message);
        }
        catch (Exception e) {
            Logger.e((String)"DTController tryShowingNotificationOffline() : ", (Throwable)e);
        }
    }

    void showScheduledNotification(String campaignId, boolean isOffline, String payload) {
        try {
            TriggerMessage message = this.dbHandler.getCampaignById(campaignId);
            if (message != null) {
                message.payload = new JSONObject(payload);
                if (isOffline) {
                    this.tryShowingNotificationOffline(message);
                } else {
                    this.showPushAndUpdateCounter(message);
                }
            } else {
                Logger.e((String)("DTController showScheduledNotification() : did not find campaign with id: " + campaignId));
            }
        }
        catch (Exception e) {
            Logger.e((String)"DTController showScheduledNotification() : ", (Throwable)e);
        }
    }

    void showPushAndUpdateCounter(TriggerMessage message) {
        try {
            if (message.rules.expiryTime < System.currentTimeMillis() || this.mConditionEvaluator.isPayloadEmpty(message)) {
                Logger.f((String)("DTController showPushAndUpdateCounter() : cannot show trigger message for campaign id: " + message.campaignId));
                return;
            }
            Bundle pushPayload = MoEUtils.jsonToBundle((JSONObject)message.payload);
            if (pushPayload == null) {
                Logger.f((String)("DTController showPushAndUpdateCounter() : could not convert json to bundle, cannot show campaign for campaign id: " + message.campaignId));
                return;
            }
            PushManager.getInstance().getPushHandler().handlePushPayload(this.mContext, pushPayload);
            this.updateCampaignState(message);
        }
        catch (Exception e) {
            Logger.f((String)"DTController showPushAndUpdateCounter() : ", (Throwable)e);
        }
    }

    void schedulePushNotification(TriggerMessage message, boolean isOffline) {
        try {
            Logger.v((String)("DTController schedulePushNotification() : will schedule notification for campaign id: " + message.campaignId));
            Intent laterIntent = new Intent(this.mContext, DTIntentService.class);
            laterIntent.putExtra("isOffline", isOffline);
            laterIntent.putExtra("NOTIFICATION_EXTRA", message.campaignId);
            laterIntent.putExtra("NOTIFICATION_PAYLOAD", message.payload.toString());
            laterIntent.setAction("ACTION_SHOW_NOTIFICATION");
            int _id = (int)System.currentTimeMillis();
            PendingIntent alarmPendingIntent = PendingIntent.getService((Context)this.mContext, (int)_id, (Intent)laterIntent, (int)0x8000000);
            AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
            if (alarmManager != null) {
                alarmManager.set(0, System.currentTimeMillis() + message.rules.showDelay, alarmPendingIntent);
            }
            PayloadBuilder builder = new PayloadBuilder();
            builder.putAttrString("campaign_id", message.campaignId);
            MoEEventManager.getInstance((Context)this.mContext).trackEvent(MoEHelperConstants.DT_CAMPAIGN_SCHEDULED, builder.build());
        }
        catch (Exception e) {
            Logger.f((String)"DTController schedulePushNotification() : ", (Throwable)e);
        }
    }

    @Nullable
    HashSet<String> getTriggerEvents() {
        return this.mTriggerEvents;
    }

    long getGlobalMinimumDelay() {
        return ConfigurationProvider.getInstance((Context)this.mContext).getDTMinimumDelay();
    }

    long getLastShowTime() {
        return ConfigurationProvider.getInstance((Context)this.mContext).getDTLastShowTime();
    }

    long getDNDStartTime() {
        return ConfigurationProvider.getInstance((Context)this.mContext).getDTDNDStartTime();
    }

    long getDNDEndTime() {
        return ConfigurationProvider.getInstance((Context)this.mContext).getDNDEndTime();
    }

    long getLastSyncTime() {
        return ConfigurationProvider.getInstance((Context)this.mContext).getDTLastSyncTime();
    }

    public static enum NETWORK_CALL_TYPE {
        SYNC_API,
        USER_IN_SEGMENT;

    }
}

