/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.addon.trigger;

import android.support.annotation.Nullable;
import com.moengage.addon.trigger.TriggerMessage;
import com.moengage.core.Logger;
import java.util.HashSet;

public class DTConditionEvaluator {
    private static final String TAG = "DTConditionEvaluator";

    boolean isDTEvent(@Nullable HashSet<String> triggerEvents, String eventName) {
        return triggerEvents != null && triggerEvents.contains(eventName);
    }

    boolean shouldShowTrigger(long lastShowTime, long globalMinimumDelay, long currentTime) {
        return lastShowTime + globalMinimumDelay < currentTime;
    }

    boolean isDNDActive(long mDNDStartTime, long mDNDEndTime, int currentHour, int currentMinutes) {
        if (mDNDEndTime == -1L || mDNDStartTime == -1L || mDNDStartTime == 0L && mDNDEndTime == 0L || mDNDEndTime == mDNDStartTime) {
            return false;
        }
        int dndStartTimeHours = 0;
        int dndStartTimeMinutes = 0;
        if (mDNDStartTime != 0L) {
            dndStartTimeHours = (int)mDNDStartTime / 100;
            dndStartTimeMinutes = (int)mDNDStartTime % 100;
        }
        int dndStopTimeHours = 0;
        int dndStopTimeMinutes = 0;
        if (mDNDEndTime != 0L) {
            dndStopTimeHours = (int)mDNDEndTime / 100;
            dndStopTimeMinutes = (int)mDNDEndTime % 100;
        }
        if (dndStartTimeHours > dndStopTimeHours) {
            if (dndStartTimeHours < currentHour || dndStopTimeHours > currentHour) {
                return true;
            }
            if (dndStartTimeHours == currentHour) {
                return currentMinutes >= dndStartTimeMinutes;
            }
            if (dndStopTimeHours == currentHour) {
                return currentMinutes <= dndStopTimeMinutes;
            }
        } else if (dndStartTimeHours < dndStopTimeHours) {
            if (currentHour > dndStartTimeHours && currentHour < dndStopTimeHours) {
                return true;
            }
            if (dndStartTimeHours == currentHour) {
                return currentMinutes >= dndStartTimeMinutes;
            }
            if (dndStopTimeHours == currentHour) {
                return currentMinutes <= dndStopTimeMinutes;
            }
        } else if (dndStartTimeHours == dndStopTimeHours) {
            return currentHour == dndStartTimeHours && currentMinutes >= dndStartTimeMinutes && currentMinutes <= dndStopTimeMinutes;
        }
        return false;
    }

    boolean canShowTriggerMessage(TriggerMessage triggerMessage, long lastSyncTime, long currentTime) {
        if (!triggerMessage.campaignType.equals("general")) {
            Logger.f((String)("DTConditionEvaluator canShowTriggerMessage() : " + triggerMessage.campaignId + " is not of type general. Cannot show"));
            return false;
        }
        if (!triggerMessage.state.isActive || triggerMessage.rules.expiryTime < currentTime) {
            Logger.f((String)("DTConditionEvaluator canShowTriggerMessage() : " + triggerMessage.campaignId + " is no longer active cannot show"));
            return false;
        }
        if (triggerMessage.rules.maxSyncDelay + lastSyncTime < currentTime && lastSyncTime != 0L) {
            Logger.f((String)("DTConditionEvaluator canShowTriggerMessage() : " + triggerMessage.campaignId + " has not been updated in a while. Cannot show without update"));
            return false;
        }
        if (triggerMessage.rules.minimumDelay + triggerMessage.state.lastShowTime > currentTime) {
            Logger.f((String)("DTConditionEvaluator canShowTriggerMessage() : " + triggerMessage.campaignId + " was shown recently. Cannot show now"));
            return false;
        }
        if (triggerMessage.rules.maxCount != -9090909L && triggerMessage.rules.maxCount <= triggerMessage.state.showCount) {
            Logger.e((String)("DTConditionEvaluatorcanShowTriggerMessage() : " + triggerMessage.campaignId + " has been shown maximum number of times. Cannot be shown again"));
            return false;
        }
        return true;
    }

    boolean isPayloadEmpty(TriggerMessage message) {
        return message.payload == null || message.payload.length() == 0;
    }
}

