/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.addon.trigger;

import android.content.Context;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.addon.trigger.DTConditionEvaluator;
import com.moengage.addon.trigger.DTController;
import com.moengage.addon.trigger.DTNetworkTask;
import com.moengage.addon.trigger.TriggerMessage;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.executor.ITask;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;

public class CheckAndShowDTCampaignTask
extends SDKTask {
    private static final String TAG = "CheckAndShowDTCampaignTask";
    private String mEventName;
    private JSONObject mEventAttributes;

    public CheckAndShowDTCampaignTask(Context context, String eventName, JSONObject eventAttributes) {
        super(context);
        this.mEventName = eventName;
        this.mEventAttributes = eventAttributes;
    }

    public TaskResult execute() {
        Logger.v((String)"CheckAndShowDTCampaignTaskexecuting :");
        try {
            DTConditionEvaluator conditionEvaluator = new DTConditionEvaluator();
            DTController dtController = DTController.getInstance(this.mContext);
            if (!conditionEvaluator.shouldShowTrigger(dtController.getLastShowTime(), dtController.getGlobalMinimumDelay(), System.currentTimeMillis())) {
                Logger.v((String)"CheckAndShowDTCampaignTaskexecute() : device trigger was shown recently cannot show now.");
                return null;
            }
            if (conditionEvaluator.isDTEvent(dtController.getTriggerEvents(), this.mEventName)) {
                Logger.v((String)("CheckAndShowDTCampaignTaskexecute() : " + this.mEventName + " is a device trigger"));
                TriggerMessage campaign = DTController.getInstance(this.mContext).getCampaignToShown(this.mEventName, this.mEventAttributes);
                if (campaign != null) {
                    Logger.v((String)("CheckAndShowDTCampaignTaskexecute() : Will try to show campaign, id: " + campaign.campaignId));
                    campaign.dump();
                    MoEDispatcher.getInstance((Context)this.mContext).addTaskToQueueBeginning((ITask)new DTNetworkTask(this.mContext, DTController.NETWORK_CALL_TYPE.USER_IN_SEGMENT, new Event(MoEHelperUtils.getDatapointJSON((String)this.mEventName.trim(), (JSONObject)this.mEventAttributes)), campaign));
                } else {
                    Logger.e((String)"CheckAndShowDTCampaignTaskexecute() : Did not find any suitable device trigger campaign to show");
                }
            } else {
                Logger.v((String)("CheckAndShowDTCampaignTask execute() : Tracked event is not a device trigger, event: " + this.mEventName));
            }
        }
        catch (Exception e) {
            Logger.f((String)"CheckAndShowDTCampaignTaskexecute() : ", (Throwable)e);
        }
        Logger.v((String)"CheckAndShowDTCampaignTaskcompleted execution : ");
        return null;
    }

    public String getTaskTag() {
        return "CHECK_AND_SHOW_DT";
    }

    public boolean isSynchronous() {
        return false;
    }
}

