package com.moengage.addon.trigger;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.os.Build.VERSION_CODES;
import com.moengage.core.Logger;
import com.moengage.core.OnJobComplete;

/**
 * @author Umang Chamaria
 */

@TargetApi(VERSION_CODES.LOLLIPOP) public class DTSyncJob extends JobService
    implements OnJobComplete {
  @Override public boolean onStartJob(JobParameters params) {
    try {
      Logger.v("DTSyncJob onStartJob() : ");
      DTHandlerImpl.getInstance()
          .syncTriggersIfRequired(getApplicationContext(), (OnJobComplete) this, params);
    } catch (Exception e) {
      Logger.f("DTSyncJob onStartJob() : ", e);
    }
    return true;
  }

  @Override public boolean onStopJob(JobParameters params) {
    return false;
  }

  @Override public void jobCompleted(JobParameters parameters, boolean needsReschedule) {
    try {
      Logger.v( "DTSyncJob: jobCompleted() : Job Completed will release lock");
      jobFinished(parameters, needsReschedule);
    } catch (Exception e) {
      Logger.f("DTSyncJob: jobCompleted() : Exception: ", e);
    }
  }
}
