package com.moengage.addon.trigger;

import android.app.job.JobParameters;
import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import com.moe.pushlibrary.models.Event;
import com.moengage.core.APIManager;
import com.moengage.core.APIResponse;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.OnJobComplete;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */

public class DTNetworkTask extends SDKTask {

  private static final String TAG = "DTNetworkTask";

  private DTController.NETWORK_CALL_TYPE mNetworkCallType;
  private Event mEvent;
  private TriggerMessage mCampaign;
  private OnJobComplete jobcompleteCallback;
  private JobParameters jobParameters;

  DTNetworkTask(Context context, DTController.NETWORK_CALL_TYPE networkCallType) {
    super(context);
    this.mNetworkCallType = networkCallType;
  }

  DTNetworkTask(Context context, DTController.NETWORK_CALL_TYPE networkCallType, Event event,
      TriggerMessage campaign) {
    this(context, networkCallType);
    this.mEvent = event;
    this.mCampaign = campaign;
  }

  DTNetworkTask(Context context, DTController.NETWORK_CALL_TYPE networkCallType,
      @Nullable OnJobComplete onJobComplete, @Nullable JobParameters parameters) {
    this(context, networkCallType);
    this.jobcompleteCallback = onJobComplete;
    this.jobParameters = parameters;
  }

  @Override public TaskResult execute() {
    try {
      Logger.v(TAG + " executing");
      APIResponse response;
      switch (mNetworkCallType) {
        case SYNC_API:
          LinkedList<String> campaigns = DTDAO.getInstance(mContext).getActiveCampaignIds();
          JSONArray campaignArray = new JSONArray();
          if (campaigns != null) {
            for (String campaign : campaigns) {
              campaignArray.put(campaign);
            }
          }
          JSONObject request = new JSONObject();
          request.put(DTConstants.REQUEST_ATTR_CAMPAIGN_IDS, campaignArray);
          request.put(DTConstants.REQUEST_ATTR_LAST_SYNC_TIME,
              ConfigurationProvider.getInstance(mContext).getDTLastSyncTime());
          response = APIManager.deviceTriggerSyncRequest(mContext,
              MoEUtils.getAPIRoute(mContext) + DTConstants.ENDPOINT_SYNC_DT, null,
              request);
          DTParser.parseAndSaveSyncAPIResponse(response, mContext);
          break;
        case USER_IN_SEGMENT:
          JSONObject requestObject = new JSONObject(mEvent.details);
          requestObject.put(DTConstants.RESPONSE_ATTR_CAMPAIGN_ID, mCampaign.campaignId);
          response = APIManager.deviceTriggerSyncRequest(mContext,
              MoEUtils.getAPIRoute(mContext) + DTConstants.ENDPOINT_USER_IN_SEGMENT, null,
              requestObject);
          DTParser.parseUserInSegmentAPIResponse(response, mCampaign, mContext);
          break;
      }
      releaseJobLockIfRequired();
      Logger.v(TAG + "completed execution");
    } catch (Exception e) {
      Logger.f(TAG + "execute() : ", e);
    }
    return null;
  }

  private void releaseJobLockIfRequired() {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP
        && jobcompleteCallback != null
        && jobParameters != null) {
      Logger.v(TAG + " releaseJobLockIfRequired() : Trying to release job lock.");
      jobcompleteCallback.jobCompleted(jobParameters, false);
    }
  }

  @Override public String getTaskTag() {
    return TAG_DT_NETWORK_CALL_TASK;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
