package com.moengage.addon.trigger;

import android.app.IntentService;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.text.TextUtils;
import com.moengage.core.Logger;

/**
 * An {@link IntentService} subclass for handling asynchronous task requests in
 * a service on a separate handler thread.
 */
public class DTIntentService extends IntentService {

  private static final String TAG = "DTIntentService";
  public DTIntentService() {
    super("DTIntentService");
  }

  @Override protected void onHandleIntent(Intent intent) {
    Logger.v(TAG + "onHandleIntent() : ");
    try {
      if (intent == null) return;
      String action  = intent.getAction();
      if (TextUtils.isEmpty(action)) return;
      Logger.v(TAG + "onHandleIntent() : Action " + action);
      switch (action){
        case DTConstants.ACTION_SYNC_MESSAGES:
          DTHandlerImpl.getInstance().syncTriggersIfRequired(getApplicationContext());
          WakefulBroadcastReceiver.completeWakefulIntent(intent);
          break;
        case DTConstants.ACTION_SHOW_NOTIFICATION:
          Bundle bundle = intent.getExtras();
          if (bundle != null){
            String campaignId = bundle.getString(DTConstants.EXTRA_SHOW_NOTIFICATION);
            boolean isOffline = bundle.getBoolean(DTConstants.EXTRA_ATTR_OFFLINE);
            String payload = bundle.getString(DTConstants.EXTRA_NOTIFICATION_PAYLOAD);
            DTController.getInstance(getApplicationContext()).showScheduledNotification
                (campaignId, isOffline, payload);
          }
          break;
      }
    } catch (Exception e) {
      Logger.f( TAG + "onHandleIntent() : ", e);
    }
  }
}
