/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.addon.trigger;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import com.moengage.addon.trigger.CheckAndShowDTCampaignTask;
import com.moengage.addon.trigger.DTController;
import com.moengage.addon.trigger.DTNetworkTask;
import com.moengage.addon.trigger.DTSyncAlarmReceiver;
import com.moengage.addon.trigger.DTSyncJob;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDTManager;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.executor.ITask;
import org.json.JSONObject;

public class DTHandlerImpl
implements MoEDTManager.DTHandler {
    private static final String TAG = "DTHandlerImpl";
    private static DTHandlerImpl _INSTANCE = null;

    public DTHandlerImpl() {
        _INSTANCE = this;
    }

    public static DTHandlerImpl getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new DTHandlerImpl();
        }
        return _INSTANCE;
    }

    public void syncTriggersIfRequired(@NonNull Context context) {
        Logger.v((String)"DTHandlerImplsyncTriggersIfRequired() : will sync if required");
        long lastSyncTime = ConfigurationProvider.getInstance((Context)context).getDTLastSyncTime();
        long minimumSyncDelay = ConfigurationProvider.getInstance((Context)context).getDTMinimumSyncDelay();
        if (lastSyncTime + minimumSyncDelay < System.currentTimeMillis()) {
            this.forceSyncDeviceTriggers(context);
        } else {
            Logger.v((String)"DTHandlerImpl syncTriggersIfRequired() : DT trigger sync not required");
        }
    }

    public void showTriggerCampaignIfPossible(@NonNull Context context, @NonNull String eventName, @NonNull JSONObject eventAttributes) {
        Logger.v((String)"DTHandlerImpl showTriggerCampaignIfPossible() : trying to show trigger campaign");
        MoEDispatcher.getInstance((Context)context).addTaskToQueueBeginning((ITask)new CheckAndShowDTCampaignTask(context, eventName, eventAttributes));
    }

    public void forceSyncDeviceTriggers(@NonNull Context context) {
        Logger.v((String)"DTHandlerImpl forceSyncDeviceTriggers() : force sync device trigger");
        MoEDispatcher.getInstance((Context)context).addTaskToQueue((ITask)new DTNetworkTask(context, DTController.NETWORK_CALL_TYPE.SYNC_API));
    }

    public void scheduleBackgroundSync(Context context) {
        Logger.v((String)"DTHandlerImpl scheduleBackgroundSync() : scheduling background fetch");
        try {
            long minimumDelayDuration = ConfigurationProvider.getInstance((Context)context).getMessageFetchDelayDuration();
            Intent alarmIntent = new Intent(context, DTSyncAlarmReceiver.class);
            alarmIntent.setAction("ACTION_SYNC_MESSAGES");
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)10002, (Intent)alarmIntent, (int)0x8000000);
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            if (Build.VERSION.SDK_INT >= 21) {
                this.scheduleFetchJob(context, minimumDelayDuration);
            } else {
                alarmManager.set(0, System.currentTimeMillis() + minimumDelayDuration, pendingIntent);
            }
        }
        catch (Exception e) {
            Logger.f((String)"DTHandlerImplscheduleBackgroundSync() : ", (Throwable)e);
        }
    }

    @TargetApi(value=21)
    private void scheduleFetchJob(Context context, long minimumDelayDuration) {
        ComponentName serviceComponent = new ComponentName(context, DTSyncJob.class);
        JobInfo.Builder builder = new JobInfo.Builder(99912, serviceComponent);
        builder.setOverrideDeadline(System.currentTimeMillis() + minimumDelayDuration + 3600000L);
        builder.setMinimumLatency(minimumDelayDuration);
        builder.setRequiredNetworkType(1);
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.schedule(builder.build());
        }
    }
}

