/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.addon.messaging;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.addon.messaging.MoEMessageSyncJob;
import com.moengage.addon.messaging.MoEMessageSyncReceiver;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.FetchMessagesFromServerTask;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.OnJobComplete;
import com.moengage.core.executor.ITask;
import com.moengage.push.MoEMessagingManager;
import com.moengage.push.PushManager;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class MessagingHandlerImpl
implements MoEMessagingManager.MessagingHandler {
    private static MessagingHandlerImpl _INSTANCE;

    public MessagingHandlerImpl() {
        _INSTANCE = this;
    }

    public static MessagingHandlerImpl getInstance() {
        if (_INSTANCE == null) {
            new MessagingHandlerImpl();
        }
        return _INSTANCE;
    }

    public void scheduleAndSyncMessages(Context context) {
        this.scheduleAndSyncMessages(context, null, null);
    }

    public void parsePayloadAndShowPush(Context context, @Nullable JSONObject payload) {
        try {
            boolean isAppOpen = false;
            if (payload != null) {
                if (payload.has("on_app_open")) {
                    isAppOpen = payload.getBoolean("on_app_open");
                }
                if (payload.has("messagesInfo")) {
                    JSONArray messageArray = payload.getJSONArray("messagesInfo");
                    for (int i = 0; i < messageArray.length(); ++i) {
                        JSONObject jsonObject;
                        Bundle bundle;
                        JSONObject message = messageArray.getJSONObject(i);
                        if (!message.has("data") || (bundle = this.jsonToBundle(jsonObject = message.getJSONObject("data"))) == null) continue;
                        this.addSourceKeyToBundle(bundle);
                        this.addForegroundKeyToBundle(bundle, isAppOpen);
                        PushManager.PushHandler handler = PushManager.getInstance().getPushHandler();
                        if (handler == null) continue;
                        handler.handlePushPayload(context, bundle);
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.f((String)"MessagingHandleImpl#parsePayloadAndShowPush: Server Response Parsing exception ", (Throwable)e);
        }
    }

    public void forceMessageSync(Context context, boolean isAppOpen) {
        this.forceMessageSync(context, isAppOpen, null, null);
    }

    public void scheduleMessageSync(Context context) {
        try {
            if (!ConfigurationProvider.getInstance((Context)context).isAppEnabled() || !ConfigurationProvider.getInstance((Context)context).isPushAmpEnabled()) {
                return;
            }
            long minimumDelayDuration = ConfigurationProvider.getInstance((Context)context).getPushAmpFetchDelayDuration();
            Intent alarmIntent = new Intent(context, MoEMessageSyncReceiver.class);
            alarmIntent.setAction("ACTION_SYNC_MESSAGES");
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)10001, (Intent)alarmIntent, (int)0x8000000);
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            if (Build.VERSION.SDK_INT >= 21) {
                this.scheduleFetchJob(context, minimumDelayDuration);
            } else {
                alarmManager.set(0, System.currentTimeMillis() + minimumDelayDuration, pendingIntent);
            }
        }
        catch (Exception e) {
            Logger.f((String)"MessagingHandleImpl#scheduleMessageSync: Exception ", (Throwable)e);
        }
    }

    @TargetApi(value=21)
    private void scheduleFetchJob(Context context, long minimumDelayDuration) {
        ComponentName serviceComponent = new ComponentName(context, MoEMessageSyncJob.class);
        JobInfo.Builder builder = new JobInfo.Builder(99911, serviceComponent);
        builder.setOverrideDeadline(System.currentTimeMillis() + minimumDelayDuration + 3600000L);
        builder.setMinimumLatency(minimumDelayDuration);
        builder.setRequiredNetworkType(1);
        if (MoEHelperUtils.hasPermission((Context)context, (String)"android.permission.RECEIVE_BOOT_COMPLETED")) {
            builder.setPersisted(true);
        }
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        jobScheduler.schedule(builder.build());
    }

    public void saveCampaignId(Context context, String campaignId) {
        try {
            ContentValues values = new ContentValues();
            values.put("campaign_id", campaignId);
            values.put("ttl", Long.valueOf(System.currentTimeMillis() + 2419200000L));
            context.getContentResolver().insert(MoEDataContract.CampaignListEntity.getContentUri((Context)context), values);
        }
        catch (Exception e) {
            Logger.f((String)"MessagingHandlerImpl#saveCampaignId: Exception : ", (Throwable)e);
        }
    }

    @Nullable
    private Bundle jsonToBundle(JSONObject json) {
        try {
            Bundle bundle = new Bundle();
            Iterator iter = json.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = json.getString(key);
                bundle.putString(key, value);
            }
            return bundle;
        }
        catch (Exception e) {
            Logger.f((String)"MessagingHandlerImpl#jsonToBundle : JSON Parsing Error", (Throwable)e);
            return null;
        }
    }

    private void addSourceKeyToBundle(Bundle bundle) {
        bundle.putString("received_from", "remote_inbox");
    }

    private void addForegroundKeyToBundle(Bundle bundle, boolean isAppOpen) {
        bundle.putBoolean("from_appOpen", isAppOpen);
    }

    void scheduleAndSyncMessages(Context context, @Nullable OnJobComplete onJobCompleteCallback, @Nullable JobParameters jobParameters) {
        try {
            Logger.v((String)"MessagingHandlerImpl scheduleAndSyncMessages() : will try to sync and ");
            if (!ConfigurationProvider.getInstance((Context)context).isAppEnabled() || !ConfigurationProvider.getInstance((Context)context).isPushAmpEnabled()) {
                return;
            }
            this.forceMessageSync(context, false, onJobCompleteCallback, jobParameters);
            this.scheduleMessageSync(context);
        }
        catch (Exception e) {
            Logger.f((String)" MessagingHandlerImpl: scheduleAndSyncMessages() : Exception ", (Throwable)e);
        }
    }

    private void forceMessageSync(Context context, boolean isAppOpen, @Nullable OnJobComplete onJobCompleteCallback, @Nullable JobParameters parameters) {
        try {
            Logger.v((String)"MessagingHandlerImpl forceMessageSync(): Will try to force sync messages ");
            if (!ConfigurationProvider.getInstance((Context)context).isAppEnabled() || !ConfigurationProvider.getInstance((Context)context).isPushAmpEnabled()) {
                return;
            }
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            long lastSyncTime = ConfigurationProvider.getInstance((Context)context).getLastMessageFetchTime();
            paramsMap.put("last_updated", Long.toString(lastSyncTime));
            if (isAppOpen) {
                paramsMap.put("on_app_open", "true");
            }
            MoEDispatcher.getInstance((Context)context).addTaskToQueue((ITask)new FetchMessagesFromServerTask(context, MoEUtils.getAPIRoute((Context)context) + "/v1/getAndroidInboxMessages", paramsMap, onJobCompleteCallback, parameters));
        }
        catch (Exception e) {
            Logger.f((String)"MessagingHandleImpl: forceMessageSync() : Exception ", (Throwable)e);
        }
    }
}

