package com.moengage.addon.messaging;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.os.Build.VERSION_CODES;
import com.moengage.core.Logger;
import com.moengage.core.OnJobComplete;

/**
 * @author Umang Chamaria
 */
@TargetApi(VERSION_CODES.LOLLIPOP)
public class MoEMessageSyncJob extends JobService implements OnJobComplete {
  @Override public boolean onStartJob(JobParameters params) {
    Logger.v("MoEMessageSyncJob: onStartJob()");
    MessagingHandlerImpl.getInstance().scheduleAndSyncMessages(getApplicationContext(), (OnJobComplete) this,
        params);
    return true;
  }

  @Override public boolean onStopJob(JobParameters params) {
    return false;
  }

  @Override public void jobCompleted(JobParameters parameters, boolean needsReschedule) {
    try {
      Logger.v("MoEMessageSyncJob: jobCompleted() Job Completed will release lock");
      jobFinished(parameters, needsReschedule);
    }catch (Exception e){
      Logger.f(  "MoEMessageSyncJob: jobCompleted() : Exception ", e);
    }
  }
}
