package com.moengage.addon.messaging;

import android.app.IntentService;
import android.content.Intent;
import android.support.v4.content.WakefulBroadcastReceiver;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.Logger;

/**
 * An {@link IntentService} subclass for handling asynchronous task requests in
 * a service on a separate handler thread.
 * <p>
 */
public class MoEMessageSyncIntentService extends IntentService {

  public MoEMessageSyncIntentService() {
    super("MoEMessageSyncIntentService");
  }

  @Override protected void onHandleIntent(Intent intent) {
    try {
      if (intent != null){
        switch (intent.getAction()){
          case MoEMessagingConstants.ACTION_SYNC_MESSAGES:
            MessagingHandlerImpl.getInstance().scheduleAndSyncMessages(getApplicationContext());
            MoEHelper.getInstance(getApplicationContext()).syncInteractionDataNow();
            WakefulBroadcastReceiver.completeWakefulIntent(intent);
            break;
        }
      }
    } catch (Exception e) {
      Logger.e("MoEMessageSyncIntentService#onHandleIntent: Exception", e);
    }
  }

}
