/*
 * Decompiled with CFR 0.152.
 */
package com.modrinth.minotaur.dependencies.container;

import com.modrinth.minotaur.dependencies.Dependency;
import com.modrinth.minotaur.dependencies.container.NamedDependency;
import com.modrinth.minotaur.dependencies.container.NamedDependencyContainer;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.model.ObjectFactory;

public class DependencyDSL {
    private final NamedDomainObjectContainer<NamedDependency> dependencies;
    private final NamedDependencyContainer.Incompatible incompatible;
    private final NamedDependencyContainer.Optional optional;
    private final NamedDependencyContainer.Required required;
    private final NamedDependencyContainer.Embedded embedded;

    @Inject
    protected DependencyDSL(ObjectFactory objects) {
        this.dependencies = objects.domainObjectContainer(NamedDependency.class);
        this.incompatible = (NamedDependencyContainer.Incompatible)objects.newInstance(NamedDependencyContainer.Incompatible.class, new Object[]{this.dependencies});
        this.optional = (NamedDependencyContainer.Optional)objects.newInstance(NamedDependencyContainer.Optional.class, new Object[]{this.dependencies});
        this.required = (NamedDependencyContainer.Required)objects.newInstance(NamedDependencyContainer.Required.class, new Object[]{this.dependencies});
        this.embedded = (NamedDependencyContainer.Embedded)objects.newInstance(NamedDependencyContainer.Embedded.class, new Object[]{this.dependencies});
    }

    public List<Dependency> getNamedDependenciesAsList() {
        return this.dependencies.stream().map(NamedDependency::getDependency).collect(Collectors.toList());
    }

    public NamedDependencyContainer.Incompatible getIncompatible() {
        return this.incompatible;
    }

    public NamedDependencyContainer.Optional getOptional() {
        return this.optional;
    }

    public NamedDependencyContainer.Required getRequired() {
        return this.required;
    }

    public NamedDependencyContainer.Embedded getEmbedded() {
        return this.embedded;
    }
}

